# دليل التثبيت والاستخدام - لاندنج بيج

## نظرة عامة

**لاندنج بيج** هو نظام متكامل لإنشاء صفحات هبوط احترافية باللغة العربية. تم تطويره ليعمل على استضافات cPanel التقليدية دون الحاجة لـ Node.js أو تقنيات معقدة.

## المتطلبات

### متطلبات السيرفر
- PHP 7.4 أو أحدث (يُفضل PHP 8.0+)
- MySQL 5.7 أو أحدث
- Apache مع mod_rewrite
- SSL Certificate (مطلوب لـ Google OAuth)

### ملحقات PHP المطلوبة
- PDO
- PDO MySQL
- cURL
- JSON
- mbstring

## خطوات التثبيت على cPanel

### 1. رفع الملفات

#### الطريقة الأولى: عبر File Manager
1. قم بتسجيل الدخول إلى cPanel
2. افتح **File Manager**
3. انتقل إلى مجلد `public_html` (أو المجلد الذي تريد التثبيت فيه)
4. ارفع جميع الملفات من مجلد `cpanel-version`
5. تأكد من رفع الملفات المخفية مثل `.htaccess`

#### الطريقة الثانية: عبر FTP
1. استخدم برنامج FTP مثل FileZilla
2. اتصل بالسيرفر باستخدام بيانات FTP الخاصة بك
3. ارفع جميع الملفات إلى المجلد المطلوب

### 2. إنشاء قاعدة البيانات

#### عبر معالج التثبيت (موصى به)
1. افتح المتصفح واذهب إلى: `http://your-domain.com/install.php`
2. اتبع خطوات معالج التثبيت
3. أدخل بيانات قاعدة البيانات عندما يُطلب منك

#### يدوياً عبر cPanel
1. افتح **MySQL Database Wizard** في cPanel
2. أنشئ قاعدة بيانات جديدة (مثلاً: `landing_page_db`)
3. أنشئ مستخدم قاعدة بيانات
4. امنح المستخدم جميع الصلاحيات على قاعدة البيانات
5. استورد ملف `database.sql` عبر phpMyAdmin

### 3. إعداد Google OAuth

#### الحصول على Google Client ID و Secret
1. اذهب إلى [Google Cloud Console](https://console.cloud.google.com/)
2. أنشئ مشروع جديد أو اختر مشروع موجود
3. فعّل **Google+ API**
4. انتقل إلى **Credentials** → **Create Credentials** → **OAuth 2.0 Client ID**
5. اختر **Web application**
6. أضف **Authorized redirect URI**:
   ```
   https://your-domain.com/auth/google-callback.php
   ```
7. احفظ **Client ID** و **Client Secret**

#### تحديث الإعدادات
إذا كنت تستخدم معالج التثبيت، سيُطلب منك إدخال هذه البيانات تلقائياً.

وإلا، قم بتحديث ملف `config/config.php` يدوياً:
```php
define('GOOGLE_CLIENT_ID', 'YOUR_CLIENT_ID_HERE');
define('GOOGLE_CLIENT_SECRET', 'YOUR_CLIENT_SECRET_HERE');
define('SITE_URL', 'https://your-domain.com');
```

### 4. ضبط الصلاحيات

تأكد من أن المجلدات التالية قابلة للكتابة:
```bash
chmod 755 uploads/
chmod 644 config/config.php
```

### 5. التحقق من التثبيت

1. افتح `https://your-domain.com`
2. يجب أن تظهر لوحة التحكم
3. جرّب تسجيل الدخول عبر Google
4. أنشئ صفحة تجريبية للتأكد من عمل كل شيء

## الاستخدام

### إنشاء صفحة جديدة

1. سجل دخولك عبر Google
2. اضغط على **إنشاء صفحة جديدة**
3. اختر النموذج المناسب لمجالك
4. املأ البيانات المطلوبة:
   - اسم الشركة
   - رقم الهاتف
   - رقم الواتساب
   - اللون الرئيسي
   - المحتوى
5. اضغط **حفظ**

### تعديل صفحة موجودة

1. من لوحة التحكم، انتقل إلى **صفحاتي**
2. اضغط على **تعديل** بجانب الصفحة المطلوبة
3. قم بتعديل المحتوى
4. اضغط **حفظ**

### مشاركة الصفحة

1. من قائمة المشاريع، اضغط على **عرض** لفتح الصفحة
2. انسخ الرابط من المتصفح
3. شاركه مع عملائك أو استخدمه في الإعلانات

## النماذج المتاحة

1. **تنسيق حدائق** - مثالي لشركات تنسيق الحدائق
2. **نقل عفش** - لشركات نقل الأثاث
3. **شراء أثاث مستعمل** - لتجار الأثاث المستعمل
4. **مقاولات عامة** - لشركات البناء والمقاولات
5. **استقدام عمالة** - لمكاتب الاستقدام
6. **ديكور وتصميم داخلي** - للمصممين
7. **رش حشرات** - لشركات مكافحة الحشرات

## استكشاف الأخطاء

### خطأ 500 - Internal Server Error
- تحقق من صلاحيات الملفات
- تأكد من أن `.htaccess` موجود وصحيح
- تحقق من إعدادات PHP في cPanel

### خطأ في الاتصال بقاعدة البيانات
- تحقق من بيانات قاعدة البيانات في `config/config.php`
- تأكد من أن قاعدة البيانات موجودة
- تحقق من صلاحيات المستخدم

### مشكلة في تسجيل الدخول عبر Google
- تأكد من صحة Google Client ID و Secret
- تحقق من إضافة Redirect URI الصحيح في Google Console
- تأكد من تفعيل SSL (HTTPS)

### الصور لا تُرفع
- تحقق من صلاحيات مجلد `uploads/`
- تأكد من أن حجم الصور أقل من 5MB
- تحقق من إعدادات `upload_max_filesize` في PHP

### الروابط لا تعمل (404)
- تأكد من تفعيل `mod_rewrite` في Apache
- تحقق من وجود ملف `.htaccess`
- تأكد من أن `AllowOverride` مسموح في إعدادات Apache

## الأمان

### توصيات أمنية

1. **احذف معالج التثبيت**
   ```bash
   rm install.php
   ```

2. **استخدم HTTPS دائماً**
   - احصل على SSL Certificate مجاني من Let's Encrypt
   - فعّل إعادة التوجيه من HTTP إلى HTTPS

3. **غيّر بيانات قاعدة البيانات الافتراضية**
   - استخدم كلمة مرور قوية
   - لا تستخدم `root` كمستخدم

4. **قم بالنسخ الاحتياطي بانتظام**
   - احفظ نسخة من قاعدة البيانات
   - احفظ نسخة من الملفات

5. **حدّث PHP و MySQL**
   - استخدم أحدث إصدارات مستقرة

## الدعم الفني

### الموارد
- [وثائق PHP](https://www.php.net/docs.php)
- [وثائق MySQL](https://dev.mysql.com/doc/)
- [دليل cPanel](https://docs.cpanel.net/)

### المشاكل الشائعة
راجع قسم **استكشاف الأخطاء** أعلاه

## الترخيص

هذا المشروع مفتوح المصدر ومتاح للاستخدام الحر.

---

**تم التطوير بواسطة:** فريق لاندنج بيج  
**الإصدار:** 1.0.0  
**آخر تحديث:** 2025
