<?php
/**
 * مصادقة Google OAuth 2.0
 * Google OAuth 2.0 Authentication
 */

define('APP_PATH', dirname(__DIR__));
require_once APP_PATH . '/config/config.php';
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/includes/functions.php';
require_once APP_PATH . '/auth/session.php';

// توليد رابط تسجيل الدخول
function getGoogleLoginUrl() {
    $params = [
        'client_id' => GOOGLE_CLIENT_ID,
        'redirect_uri' => GOOGLE_REDIRECT_URI,
        'response_type' => 'code',
        'scope' => 'openid email profile',
        'access_type' => 'offline',
        'prompt' => 'consent'
    ];
    
    return 'https://accounts.google.com/o/oauth2/v2/auth?' . http_build_query($params);
}

// التحقق من التسجيل وبدء عملية OAuth
if (!isset($_GET['code'])) {
    redirect(getGoogleLoginUrl());
}

// استبدال الكود بـ Access Token
$code = $_GET['code'];

$tokenUrl = 'https://oauth2.googleapis.com/token';
$tokenParams = [
    'code' => $code,
    'client_id' => GOOGLE_CLIENT_ID,
    'client_secret' => GOOGLE_CLIENT_SECRET,
    'redirect_uri' => GOOGLE_REDIRECT_URI,
    'grant_type' => 'authorization_code'
];

$ch = curl_init($tokenUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($tokenParams));
$response = curl_exec($ch);
curl_close($ch);

$tokenData = json_decode($response, true);

if (!isset($tokenData['access_token'])) {
    die('فشل الحصول على Access Token');
}

// الحصول على معلومات المستخدم
$userInfoUrl = 'https://www.googleapis.com/oauth2/v2/userinfo';
$ch = curl_init($userInfoUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $tokenData['access_token']
]);
$userInfoResponse = curl_exec($ch);
curl_close($ch);

$googleUser = json_decode($userInfoResponse, true);

if (!isset($googleUser['id'])) {
    die('فشل الحصول على معلومات المستخدم');
}

// البحث عن المستخدم أو إنشاء حساب جديد
$user = findUserByGoogleId($googleUser['id']);

if (!$user) {
    // التحقق من البريد الإلكتروني
    $user = findUserByEmail($googleUser['email']);
    
    if ($user) {
        // ربط حساب Google بالمستخدم الموجود
        update('users', ['google_id' => $googleUser['id']], 'id = :id', ['id' => $user['id']]);
    } else {
        // إنشاء مستخدم جديد
        $userId = createUserFromGoogle($googleUser);
        $user = findUserByGoogleId($googleUser['id']);
    }
}

// حفظ معلومات OAuth
saveOAuthAccount($user['id'], 'google', $googleUser['id'], $tokenData);

// تسجيل دخول المستخدم
loginUser($user['id'], true);

// إعادة التوجيه للوحة التحكم
redirect(SITE_URL . '/index.php');
