<?php
/**
 * ملف الإعدادات الرئيسي
 * Landing Page Builder - Configuration File
 */

// منع الوصول المباشر
if (!defined('APP_PATH')) {
    define('APP_PATH', dirname(__DIR__));
}

// إعدادات قاعدة البيانات
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'landing_page_db');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// إعدادات الموقع
// Site Configuration
define('SITE_NAME', 'لاندنج بيج');
define('SITE_URL', 'http://localhost/site2/cpanel-version');
define('SITE_LANG', 'ar');

// إعدادات Google OAuth
// Google OAuth Configuration
define('GOOGLE_CLIENT_ID', 'YOUR_GOOGLE_CLIENT_ID');
define('GOOGLE_CLIENT_SECRET', 'YOUR_GOOGLE_CLIENT_SECRET');
define('GOOGLE_REDIRECT_URI', SITE_URL . '/auth/google-callback.php');

// إعدادات الجلسات
// Session Configuration
define('SESSION_NAME', 'landing_page_session');
define('SESSION_LIFETIME', 86400 * 30); // 30 يوم

// إعدادات الأمان
// Security Configuration
define('SECURE_KEY', 'change-this-to-random-string-' . md5(__DIR__));
define('CSRF_TOKEN_NAME', 'csrf_token');

// إعدادات التحميلات
// Upload Configuration
define('UPLOAD_PATH', APP_PATH . '/uploads');
define('UPLOAD_MAX_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGES', ['jpg', 'jpeg', 'png', 'gif', 'webp']);

// إعدادات الأخطاء
// Error Configuration
if (!defined('PRODUCTION')) {
    define('PRODUCTION', false);
}

if (PRODUCTION) {
    error_reporting(0);
    ini_set('display_errors', 0);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

// المنطقة الزمنية
// Timezone
date_default_timezone_set('Asia/Riyadh');

// تشفير
// Encryption
define('ENCRYPTION_METHOD', 'AES-256-CBC');
