<?php
/**
 * ملف الاتصال بقاعدة البيانات
 * Database Connection Handler
 */

class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES " . DB_CHARSET
            ];
            
            $this->connection = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            die("Database Connection Error: " . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    // منع الاستنساخ
    private function __clone() {}
    
    // منع التسلسل
    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }
}

/**
 * دالة مساعدة للحصول على الاتصال
 * Helper function to get database connection
 */
function getDB() {
    return Database::getInstance()->getConnection();
}

/**
 * تنفيذ استعلام وإرجاع النتائج
 * Execute query and return results
 */
function query($sql, $params = []) {
    $db = getDB();
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    return $stmt;
}

/**
 * جلب صف واحد
 * Fetch single row
 */
function fetchOne($sql, $params = []) {
    $stmt = query($sql, $params);
    return $stmt->fetch();
}

/**
 * جلب جميع الصفوف
 * Fetch all rows
 */
function fetchAll($sql, $params = []) {
    $stmt = query($sql, $params);
    return $stmt->fetchAll();
}

/**
 * إدراج بيانات وإرجاع آخر ID
 * Insert data and return last insert ID
 */
function insert($table, $data) {
    $db = getDB();
    $keys = array_keys($data);
    $fields = implode(', ', $keys);
    $placeholders = ':' . implode(', :', $keys);
    
    $sql = "INSERT INTO {$table} ({$fields}) VALUES ({$placeholders})";
    $stmt = $db->prepare($sql);
    $stmt->execute($data);
    
    return $db->lastInsertId();
}

/**
 * تحديث بيانات
 * Update data
 */
function update($table, $data, $where, $whereParams = []) {
    $db = getDB();
    $setParts = [];
    
    foreach ($data as $key => $value) {
        $setParts[] = "{$key} = :{$key}";
    }
    
    $setClause = implode(', ', $setParts);
    $sql = "UPDATE {$table} SET {$setClause} WHERE {$where}";
    
    $params = array_merge($data, $whereParams);
    $stmt = $db->prepare($sql);
    
    return $stmt->execute($params);
}

/**
 * حذف بيانات
 * Delete data
 */
function delete($table, $where, $params = []) {
    $db = getDB();
    $sql = "DELETE FROM {$table} WHERE {$where}";
    $stmt = $db->prepare($sql);
    
    return $stmt->execute($params);
}

/**
 * عد الصفوف
 * Count rows
 */
function count($table, $where = '1=1', $params = []) {
    $sql = "SELECT COUNT(*) as count FROM {$table} WHERE {$where}";
    $result = fetchOne($sql, $params);
    return $result['count'] ?? 0;
}
