<?php
/**
 * الصفحة الرئيسية - لوحة التحكم
 * Dashboard - Main Page
 */

define('APP_PATH', __DIR__);
require_once APP_PATH . '/config/config.php';
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/includes/functions.php';
require_once APP_PATH . '/auth/session.php';

$user = getCurrentUser();
$pageTitle = 'لوحة التحكم';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?> - <?php echo $pageTitle; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        body { font-family: 'Cairo', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

<div class="flex h-screen bg-gray-50 font-sans" dir="rtl">
    <!-- Mobile Header -->
    <div class="md:hidden fixed top-0 left-0 right-0 bg-white border-b border-gray-200 p-4 z-50 flex justify-between items-center">
        <div class="flex items-center gap-3">
            <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center text-white font-bold">L</div>
            <span class="font-bold text-xl text-gray-800"><?php echo SITE_NAME; ?></span>
        </div>
        <button onclick="toggleMobileMenu()" class="p-2 text-gray-600">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
            </svg>
        </button>
    </div>

    <!-- Sidebar -->
    <aside id="sidebar" class="fixed inset-y-0 right-0 w-64 bg-white border-l border-gray-200 flex flex-col z-40 transform transition-transform duration-300 ease-in-out md:translate-x-0 translate-x-full">
        <div class="p-6 border-b border-gray-100 hidden md:block">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center text-white font-bold">L</div>
                <span class="font-bold text-xl text-gray-800"><?php echo SITE_NAME; ?></span>
            </div>
        </div>

        <nav class="flex-1 p-4 space-y-2 mt-16 md:mt-0">
            <a href="#" onclick="setActiveTab('home'); return false;" id="nav-home" class="nav-item w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-colors bg-blue-50 text-blue-600 font-bold">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                الرئيسية
            </a>
            <a href="#" onclick="setActiveTab('projects'); return false;" id="nav-projects" class="nav-item w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-colors text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
                صفحاتي
            </a>
            <a href="#" onclick="setActiveTab('templates'); return false;" id="nav-templates" class="nav-item w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-colors text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h14a1 1 0 011 1v2a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM4 13a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H5a1 1 0 01-1-1v-6zM16 13a1 1 0 011-1h2a1 1 0 011 1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-6z"></path>
                </svg>
                النماذج
            </a>
        </nav>

        <div class="p-4 border-t border-gray-100">
            <?php if ($user): ?>
                <div class="flex items-center gap-3 mb-4">
                    <?php if ($user['image']): ?>
                        <img src="<?php echo htmlspecialchars($user['image']); ?>" alt="<?php echo htmlspecialchars($user['name']); ?>" class="w-8 h-8 rounded-full">
                    <?php endif; ?>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-gray-900 truncate"><?php echo htmlspecialchars($user['name']); ?></p>
                        <p class="text-xs text-gray-500 truncate"><?php echo htmlspecialchars($user['email']); ?></p>
                    </div>
                </div>
                <a href="<?php echo SITE_URL; ?>/auth/logout.php" class="w-full flex items-center gap-3 px-4 py-3 text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                    </svg>
                    تسجيل خروج
                </a>
            <?php else: ?>
                <a href="<?php echo SITE_URL; ?>/auth/google-callback.php" class="w-full flex items-center gap-3 px-4 py-3 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                    </svg>
                    تسجيل دخول
                </a>
            <?php endif; ?>
        </div>
    </aside>

    <!-- Overlay for mobile -->
    <div id="overlay" class="fixed inset-0 bg-black/20 z-30 md:hidden hidden" onclick="toggleMobileMenu()"></div>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-4 md:p-8 mt-16 md:mt-0">
        <!-- Header -->
        <header class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 gap-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-900" id="page-title">لوحة التحكم</h1>
                <p class="text-gray-500 mt-1 text-sm md:text-base" id="page-subtitle">
                    <?php if ($user): ?>
                        مرحباً <?php echo htmlspecialchars(explode(' ', $user['name'])[0]); ?>، ابدأ بإنشاء صفحة هبوط احترافية.
                    <?php else: ?>
                        أهلاً بك، سجل دخولك لحفظ مشاريعك.
                    <?php endif; ?>
                </p>
            </div>
            <button onclick="setActiveTab('templates')" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-lg font-bold flex items-center justify-center gap-2 transition-colors shadow-sm">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                إنشاء صفحة جديدة
            </button>
        </header>

        <!-- Content Sections -->
        <div id="home-section" class="content-section">
            <!-- Stats -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-6 mb-8">
                <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
                    <div class="text-gray-500 mb-2">إجمالي الصفحات</div>
                    <div class="text-3xl font-bold text-gray-900" id="stat-projects">0</div>
                </div>
                <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
                    <div class="text-gray-500 mb-2">الزيارات</div>
                    <div class="text-3xl font-bold text-gray-900" id="stat-views">0</div>
                </div>
                <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
                    <div class="text-gray-500 mb-2">النماذج المتاحة</div>
                    <div class="text-3xl font-bold text-gray-900">7</div>
                </div>
            </div>

            <!-- Recent Projects -->
            <div class="mb-12">
                <h2 class="text-lg font-bold text-gray-800 mb-4 flex items-center justify-between">
                    <span>آخر المشاريع</span>
                    <button onclick="setActiveTab('projects')" class="text-sm text-blue-600 hover:underline">عرض الكل</button>
                </h2>
                <div id="recent-projects-list"></div>
            </div>
        </div>

        <div id="projects-section" class="content-section hidden">
            <h2 class="text-lg font-bold text-gray-800 mb-4">جميع المشاريع</h2>
            <div id="all-projects-list"></div>
        </div>

        <div id="templates-section" class="content-section hidden">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6" id="templates-grid"></div>
        </div>
    </main>
</div>

<script src="<?php echo SITE_URL; ?>/assets/js/dashboard.js"></script>
<script>
const SITE_URL = '<?php echo SITE_URL; ?>';
const IS_LOGGED_IN = <?php echo $user ? 'true' : 'false'; ?>;
</script>

</body>
</html>
