import { prisma } from './src/lib/prisma';

async function main() {
    try {
        console.log('Connecting to database...');
        const userCount = await prisma.user.count();
        console.log(`Successfully connected. User count: ${userCount}`);

        const projectCount = await prisma.project.count();
        console.log(`Project count: ${projectCount}`);
    } catch (e) {
        console.error('Database connection failed:', e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
