<?php
// db.php
try {
    // Create (connect to) SQLite database in file
    $db = new PDO('sqlite:' . __DIR__ . '/landing_builder.sqlite');
    // Set errormode to exceptions
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Fetch results as associative arrays by default
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    // Print error message
    die("Database Connection Error: " . $e->getMessage());
}

function get_project_by_slug($slug) {
    global $db;
    $stmt = $db->prepare("SELECT * FROM projects WHERE slug = :slug");
    $stmt->execute([':slug' => $slug]);
    return $stmt->fetch();
}

function get_project_by_id($id) {
    global $db;
    $stmt = $db->prepare("SELECT * FROM projects WHERE id = :id");
    $stmt->execute([':id' => $id]);
    return $stmt->fetch();
}
?>
