<?php
require_once 'db.php';

// Get slug from query string (e.g., .htaccess rewrites /p/slug -> index.php?slug=slug)
// Or just basic parameter for now: index.php?p=slug
$slug = $_GET['p'] ?? '';

if (!$slug) {
    die("No project specified.");
}

$project = get_project_by_slug($slug);

if (!$project) {
    http_response_code(404);
    die("Project not found.");
}

// Data is stored as JSON string in DB
$data = json_decode($project['data'], true);
$templateId = $project['template_id'];

// Map template IDs to files
$templateFiles = [
    'landscaping' => 'templates/landscaping.php',
    'moving' => 'templates/moving.php',
    'used-furniture' => 'templates/used-furniture.php',
    'contracting' => 'templates/contracting.php',
    'recruitment' => 'templates/recruitment.php',
    'decor' => 'templates/decor.php',
    'pest-control' => 'templates/pest-control.php',
];

if (!isset($templateFiles[$templateId])) {
    die("Template not found.");
}

$templateFile = $templateFiles[$templateId];

// View Tracker (Simple native PHP implementation)
// Increment view count
$stmt = $db->prepare("UPDATE projects SET views = views + 1 WHERE id = :id");
$stmt->execute([':id' => $project['id']]);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($data['seoTitle'] ?? $project['name']) ?></title>
    <meta name="description" content="<?= htmlspecialchars($data['seoDescription'] ?? '') ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap');

        body {
            font-family: 'Cairo', sans-serif;
        }
    </style>
</head>

<body>
    <?php include $templateFile; ?>

    <!-- Floating WhatsApp -->
    <?php if (!empty($data['whatsapp'])): ?>
        <a href="https://wa.me/<?= htmlspecialchars($data['whatsapp']) ?>" target="_blank"
            class="fixed bottom-6 right-6 bg-green-500 text-white p-4 rounded-full shadow-lg hover:bg-green-600 transition-colors z-50 flex items-center justify-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path
                    d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z">
                </path>
            </svg>
        </a>
    <?php endif; ?>

    <!-- Branding -->
    <div
        class="fixed bottom-4 left-4 bg-white/90 backdrop-blur shadow-lg rounded-full px-4 py-2 text-xs font-bold text-gray-600 z-40 border border-gray-200">
        تم الإنشاء بواسطة منصة الهبوط
    </div>
</body>

</html>