<?php
// templates/recruitment.php
$data = $data ?? [];
?>
<div class="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
    <header class="bg-blue-900 text-white py-20 relative overflow-hidden">
        <div class="container mx-auto px-4 relative z-10 text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6"><?= htmlspecialchars($data['heroTitle'] ?? '') ?></h1>
            <p class="text-xl text-blue-100 mb-10 max-w-3xl mx-auto">
                <?= htmlspecialchars($data['heroDescription'] ?? '') ?></p>
            <div class="flex gap-4 justify-center">
                <a href="tel:<?= htmlspecialchars($data['phone'] ?? '') ?>"
                    class="bg-white text-blue-900 px-8 py-3 rounded-full font-bold hover:bg-gray-100 transition-colors">
                    اتصل بنا الآن
                </a>
            </div>
        </div>
    </header>

    <section class="py-16">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-3xl font-bold mb-12">دول الاستقدام</h2>
            <p class="text-2xl text-blue-800 font-medium"><?= htmlspecialchars($data['countries'] ?? '') ?></p>
        </div>
    </section>

    <footer class="bg-gray-100 py-8 text-center">
        <p class="text-gray-600 mb-2"><?= htmlspecialchars($data['companyName'] ?? '') ?></p>
        <p class="text-gray-500 text-sm"><?= htmlspecialchars($data['licenseNumber'] ?? '') ?></p>
    </footer>
</div>