import { prisma } from '../src/lib/prisma';

async function main() {
    try {
        console.log('Testing DB connection...');
        const count = await prisma.project.count();
        console.log('Connection successful. Project count:', count);

        console.log('Attempting to create a test project...');
        const testProject = await prisma.project.create({
            data: {
                id: 'test-' + Date.now(),
                templateId: 'test',
                name: 'Test Project',
                slug: 'test-' + Date.now(),
                data: '{}',
                views: 0
            }
        });
        console.log('Test project created:', testProject.id);

        await prisma.project.delete({ where: { id: testProject.id } });
        console.log('Test project deleted.');

    } catch (e) {
        console.error('DB Test Failed:', e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
