import { Phone, MessageCircle, HardHat, Ruler, Hammer, Building2, CheckCircle2, ArrowRight } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection'; // Although not in data, we can conditionally render if data exists or skip

export default function ContractingTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#f59e0b'; // Amber-500

    // Gallery Images
    const galleryImages = [
        data.project1,
        data.project2,
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
        data.galleryImage4,
    ].filter(Boolean);

    // No specific testimonial fields in templates.ts for Contracting yet, 
    // but we can look for generic ones or just skip. 
    // Wait, I didn't add testimonial fields to Contracting in templates.ts update step 151?
    // Let's check... I see `Stats` and `Gallery` there. I missed Testimonials for Contracting.
    // I will mock them or skip. Better to skip if empty. 
    // Actually, I can use generic names if available.

    // Let's assume user might add them later or we rely on existing fields.
    const testimonials: any[] = [];

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero */}
            <header className="relative h-[85vh] min-h-[600px] bg-gray-900 text-white overflow-hidden">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1503387762-592deb58ef4e?auto=format&fit=crop&q=80')] bg-cover bg-center" />
                <div className="absolute inset-0 bg-gradient-to-r from-black via-black/80 to-transparent/50" />

                {/* Decorative Elements */}
                <div className="absolute top-0 right-0 w-1/3 h-full bg-yellow-500/10 skew-x-12 transform origin-top-right"></div>

                <div className="relative container mx-auto px-4 h-full flex flex-col justify-center">
                    <div className="max-w-3xl animate-fade-in-right">
                        <div className="flex items-center gap-2 mb-6 text-yellow-500 font-bold tracking-wider uppercase">
                            <Building2 className="w-5 h-5" />
                            <span>ريادة في عالم المقاولات</span>
                        </div>
                        <h1 className="text-5xl md:text-7xl font-bold mb-8 leading-tight">
                            {data.heroTitle}
                            <span className="block text-yellow-500 mt-2 text-4xl md:text-6xl">بمعايير عالمية</span>
                        </h1>
                        <p className="text-xl text-gray-300 mb-12 leading-relaxed max-w-2xl border-r-4 border-yellow-500 pr-6">
                            {data.heroDescription}
                        </p>
                        <div className="flex flex-col sm:flex-row gap-4">
                            <a href={`tel:${data.phone}`} className="bg-yellow-500 hover:bg-yellow-400 text-black px-10 py-4 rounded-sm font-bold flex items-center justify-center gap-3 transition-transform hover:-translate-y-1 shadow-lg shadow-yellow-500/20">
                                <Phone className="w-5 h-5" />
                                اطلب عرض سعر
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-transparent border-2 border-white/20 hover:border-yellow-500 text-white hover:text-yellow-500 px-10 py-4 rounded-sm font-bold flex items-center justify-center gap-3 transition-colors">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>
                </div>
            </header>

            {/* Stats Section */}
            <div className="bg-yellow-500 py-12 relative z-20 -mt-20 mx-4 md:mx-0 shadow-2xl">
                <div className="container mx-auto px-4">
                    <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center divide-x divide-x-reverse divide-black/10">
                        <div className="p-4">
                            <div className="text-4xl font-bold text-black mb-1">{data.yearExp}+</div>
                            <div className="text-black/70 font-bold">سنوات خبرة</div>
                        </div>
                        <div className="p-4">
                            <div className="text-4xl font-bold text-black mb-1">{data.projectCount}+</div>
                            <div className="text-black/70 font-bold">مشاريع منجزة</div>
                        </div>
                        <div className="p-4">
                            <div className="text-4xl font-bold text-black mb-1">100%</div>
                            <div className="text-black/70 font-bold">التزام بالمواعيد</div>
                        </div>
                        <div className="p-4">
                            <div className="text-4xl font-bold text-black mb-1">24/7</div>
                            <div className="text-black/70 font-bold">دعم فني</div>
                        </div>
                    </div>
                </div>
            </div>

            {/* Services Grid */}
            <section className="py-24 bg-white relative overflow-hidden">
                <div className="absolute top-0 left-0 w-64 h-64 bg-gray-50 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
                <div className="absolute top-0 right-0 w-64 h-64 bg-yellow-50 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>

                <div className="container mx-auto px-4 relative z-10">
                    <div className="text-center mb-16">
                        <h2 className="text-4xl font-bold mb-4 text-gray-900">خدماتنا</h2>
                        <div className="w-20 h-1 bg-yellow-500 mx-auto"></div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-8">
                        <div className="bg-white p-10 shadow-xl shadow-gray-200/50 group hover:-translate-y-2 transition-transform duration-300 border-t-4 border-transparent hover:border-yellow-500">
                            <div className="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center mb-8 group-hover:bg-yellow-500 transition-colors duration-300">
                                <HardHat className="w-8 h-8 text-gray-600 group-hover:text-black" />
                            </div>
                            <h3 className="text-2xl font-bold mb-4 group-hover:text-yellow-600 transition-colors">مقاولات عامة</h3>
                            <p className="text-gray-500 leading-relaxed mb-6">تنفيذ جميع أعمال البناء والإنشاءات العظم والتشطيب بأعلى معايير الجودة الهندسية.</p>
                            <ul className="space-y-2 text-sm text-gray-600">
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> بناء فلل وقصور</li>
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> مباني تجارية</li>
                            </ul>
                        </div>

                        <div className="bg-white p-10 shadow-xl shadow-gray-200/50 group hover:-translate-y-2 transition-transform duration-300 border-t-4 border-transparent hover:border-yellow-500">
                            <div className="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center mb-8 group-hover:bg-yellow-500 transition-colors duration-300">
                                <Ruler className="w-8 h-8 text-gray-600 group-hover:text-black" />
                            </div>
                            <h3 className="text-2xl font-bold mb-4 group-hover:text-yellow-600 transition-colors">تشطيبات وديكور</h3>
                            <p className="text-gray-500 leading-relaxed mb-6">تشطيبات داخلية وخارجية، دهانات، جبس بورد، وأرضيات بلمسات عصرية.</p>
                            <ul className="space-y-2 text-sm text-gray-600">
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> واجهات خارجية</li>
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> ديكورات داخلية</li>
                            </ul>
                        </div>

                        <div className="bg-white p-10 shadow-xl shadow-gray-200/50 group hover:-translate-y-2 transition-transform duration-300 border-t-4 border-transparent hover:border-yellow-500">
                            <div className="w-16 h-16 bg-gray-100 rounded-lg flex items-center justify-center mb-8 group-hover:bg-yellow-500 transition-colors duration-300">
                                <Hammer className="w-8 h-8 text-gray-600 group-hover:text-black" />
                            </div>
                            <h3 className="text-2xl font-bold mb-4 group-hover:text-yellow-600 transition-colors">ترميم وصيانة</h3>
                            <p className="text-gray-500 leading-relaxed mb-6">إعادة تأهيل المباني القديمة وصيانتها وإصلاح التصدعات ومعالجة التسربات.</p>
                            <ul className="space-y-2 text-sm text-gray-600">
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> ترميم شامل</li>
                                <li className="flex items-center gap-2"><CheckCircle2 className="w-4 h-4 text-yellow-500" /> عوازل أسطح</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <GallerySection
                images={galleryImages}
                title={data.galleryTitle || "مشاريعنا"}
                description="شاهد جودة أعمالنا ودقة التنفيذ في مشاريعنا السابقة"
                primaryColor={primaryColor}
            />

            {/* CTA Section */}
            <div className="bg-gray-900 py-20 relative overflow-hidden">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1541888946425-d81bb19240f5?auto=format&fit=crop&q=80')] bg-cover bg-fixed opacity-10"></div>
                <div className="container mx-auto px-4 relative z-10 flex flex-col md:flex-row items-center justify-between gap-10">
                    <div className="text-white max-w-2xl">
                        <h2 className="text-3xl md:text-4xl font-bold mb-4">هل لديك مشروع قادم؟</h2>
                        <p className="text-gray-300 text-lg leading-relaxed">
                            دعنا نساعدك في تحويل مخططاتك إلى واقع ملموس. فريقنا الهندسي جاهز لتقديم الاستشارات وعروض الأسعار المناسبة لميزانيتك.
                        </p>
                    </div>
                    <div className="flex-shrink-0">
                        <a href={`tel:${data.phone}`} className="bg-yellow-500 hover:bg-yellow-400 text-black text-lg px-10 py-5 rounded-sm font-bold flex items-center gap-3 transition-colors shadow-xl">
                            تواصل معنا مجاناً
                            <ArrowRight className="w-5 h-5" />
                        </a>
                    </div>
                </div>
            </div>

            {/* Footer */}
            <footer className="bg-black text-white py-12 border-t border-gray-800">
                <div className="container mx-auto px-4 text-center">
                    <h2 className="text-2xl font-bold mb-6 text-yellow-500">{data.companyName}</h2>
                    <p className="text-gray-500 mb-8 max-w-md mx-auto">شريكك الموثوق في عالم البناء والمقاولات. نلتزم بالجودة، الأمان، والمواعيد.</p>

                    <div className="flex justify-center gap-4 mb-8">
                        <a href={`tel:${data.phone}`} className="w-12 h-12 border border-gray-700 hover:border-yellow-500 hover:text-yellow-500 rounded flex items-center justify-center transition-all">
                            <Phone className="w-5 h-5" />
                        </a>
                        <a href={`https://wa.me/${data.whatsapp}`} className="w-12 h-12 border border-gray-700 hover:border-yellow-500 hover:text-yellow-500 rounded flex items-center justify-center transition-all">
                            <MessageCircle className="w-5 h-5" />
                        </a>
                    </div>

                    <p className="text-sm text-gray-700">&copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.</p>
                </div>
            </footer>
        </div>
    );
}
