import { Phone, MessageCircle, Ruler, Paintbrush, Armchair, ChevronDown } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection';

export default function DecorTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#c084fc'; // Default purple-400 equivalent

    // Gallery Images
    const galleryImages = [
        data.portfolio1,
        data.portfolio2,
        data.portfolio3,
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
        data.galleryImage4,
        data.galleryImage5,
        data.galleryImage6,
    ].filter(Boolean);

    // Testimonials
    const testimonials = [
        { name: data.clientName1, text: data.clientReview1, rating: 5 },
        { name: data.clientName2, text: data.clientReview2, rating: 5 },
    ].filter(t => t.name && t.text);

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full selection:bg-purple-100" dir="rtl">
            {/* Hero Section */}
            <header className="relative h-[80vh] min-h-[600px] text-white overflow-hidden flex items-center justify-center">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1618221195710-dd6b41faaea6?auto=format&fit=crop&q=80')] bg-cover bg-center" />
                <div className="absolute inset-0 bg-gray-900/60 transition-opacity hover:bg-gray-900/50 duration-700" />

                <div className="container mx-auto px-4 relative z-10 text-center">
                    <div className="inline-block px-8 py-3 bg-white/10 backdrop-blur-md rounded-full border border-white/20 mb-8 animate-fade-in-up">
                        <span className="uppercase tracking-[0.2em] text-sm">التصميم الداخلي الفاخر</span>
                    </div>
                    <h1 className="text-5xl md:text-7xl font-light mb-8 leading-tight animate-fade-in-up delay-100">{data.heroTitle}</h1>
                    <p className="text-xl md:text-2xl mb-12 text-gray-200 max-w-2xl mx-auto font-light leading-relaxed animate-fade-in-up delay-200">{data.heroDescription}</p>
                    <div className="flex flex-col sm:flex-row gap-6 justify-center animate-fade-in-up delay-300">
                        <a href={`tel:${data.phone}`} className="bg-white text-gray-900 px-10 py-4 rounded-none font-bold hover:bg-gray-100 transition-colors duration-300 tracking-wide uppercase text-sm flex items-center justify-center gap-3">
                            <Phone className="w-4 h-4" />
                            اتصل بنا
                        </a>
                        <a href="#portfolio" className="bg-transparent border border-white text-white px-10 py-4 rounded-none font-bold hover:bg-white hover:text-gray-900 transition-all duration-300 tracking-wide uppercase text-sm">
                            شاهد أعمالنا
                        </a>
                    </div>
                </div>

                <div className="absolute bottom-10 left-1/2 -translate-x-1/2 animate-bounce">
                    <ChevronDown className="w-8 h-8 text-white/50" />
                </div>
            </header>

            {/* Intro Grid */}
            <section className="py-24 bg-white">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-2 gap-16 items-center">
                        <div className="space-y-8">
                            <h2 className="text-4xl font-light text-gray-900 leading-tight">نصمم مساحات <br /><span className="font-bold border-b-4 border-purple-200">تلهم حياتك</span></h2>
                            <p className="text-gray-600 leading-loose text-lg">
                                نحن نؤمن بأن التصميم الداخلي ليس مجرد تزيين للمكان، بل هو خلق بيئة تعكس شخصيتك وتلبي احتياجاتك اليومية بأسلوب فني راقٍ.
                            </p>
                            <div className="grid grid-cols-2 gap-8 pt-8">
                                <div>
                                    <h4 className="text-5xl font-light text-gray-900 mb-2">50+</h4>
                                    <p className="text-gray-500 uppercase tracking-wider text-sm">مشروع سكني</p>
                                </div>
                                <div>
                                    <h4 className="text-5xl font-light text-gray-900 mb-2">20+</h4>
                                    <p className="text-gray-500 uppercase tracking-wider text-sm">مساحة تجارية</p>
                                </div>
                            </div>
                        </div>
                        <div className="grid grid-cols-2 gap-4">
                            <img src="https://images.unsplash.com/photo-1616486338812-3dadae4b4f9d?auto=format&fit=crop&q=80" className="w-full h-80 object-cover mt-12 shadow-2xl" alt="Interior 1" />
                            <img src="https://images.unsplash.com/photo-1616137466211-f939a420be84?auto=format&fit=crop&q=80" className="w-full h-80 object-cover shadow-2xl" alt="Interior 2" />
                        </div>
                    </div>
                </div>
            </section>

            {/* Services Minimal */}
            <section className="py-24 bg-gray-50">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-3 gap-12">
                        <div className="text-center group">
                            <div className="w-20 h-20 mx-auto bg-white border border-gray-100 flex items-center justify-center mb-8 shadow-sm group-hover:shadow-md transition-shadow">
                                <Ruler className="w-8 h-8 text-gray-400 group-hover:text-purple-600 transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4">تخطيط المساحات</h3>
                            <p className="text-gray-500 leading-relaxed font-light">نستغل كل زاوية في منزلك بذكاء لتحقيق أقصى استفادة وظيفية وجمالية.</p>
                        </div>
                        <div className="text-center group">
                            <div className="w-20 h-20 mx-auto bg-white border border-gray-100 flex items-center justify-center mb-8 shadow-sm group-hover:shadow-md transition-shadow">
                                <Paintbrush className="w-8 h-8 text-gray-400 group-hover:text-purple-600 transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4">اختيار الألوان</h3>
                            <p className="text-gray-500 leading-relaxed font-light">دمج ألوان متناغم يخلق جواً من الراحة والفخامة في آن واحد.</p>
                        </div>
                        <div className="text-center group">
                            <div className="w-20 h-20 mx-auto bg-white border border-gray-100 flex items-center justify-center mb-8 shadow-sm group-hover:shadow-md transition-shadow">
                                <Armchair className="w-8 h-8 text-gray-400 group-hover:text-purple-600 transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4">تأثيث وديكور</h3>
                            <p className="text-gray-500 leading-relaxed font-light">نختار لك أثاثاً وقطع ديكور فريدة تضفي طابعاً خاصاً على مساحتك.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <div id="portfolio">
                <GallerySection
                    images={galleryImages}
                    title={data.galleryTitle || "أحدث إبداعاتنا"}
                    description="جولة في عالم من الأناقة والجمال بتوقيع خبرائنا"
                />
            </div>

            {/* Testimonials Section */}
            <TestimonialsSection
                testimonials={testimonials}
                title="ماذا يقول عملاؤنا"
            />

            {/* Footer */}
            <footer className="bg-white text-gray-900 py-16 border-t border-gray-100">
                <div className="container mx-auto px-4 flex flex-col items-center">
                    <h2 className="text-3xl font-light mb-8 tracking-widest uppercase">{data.companyName}</h2>
                    <div className="flex gap-8 mb-12">
                        <a href={`tel:${data.phone}`} className="text-gray-400 hover:text-gray-900 transition-colors">
                            <Phone className="w-6 h-6" />
                        </a>
                        <a href={`https://wa.me/${data.whatsapp}`} className="text-gray-400 hover:text-gray-900 transition-colors">
                            <MessageCircle className="w-6 h-6" />
                        </a>
                    </div>
                    <div className="text-center text-sm text-gray-400 font-light">
                        <p className="mb-2">جميع التصاميم محمية بحقوق النشر &copy; {new Date().getFullYear()}</p>
                        {data.companyName}
                    </div>
                </div>
            </footer>
        </div>
    );
}
