import { Phone, MessageCircle, Trees, Flower2, Droplets, Leaf, Sprout, Sun } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection';

export default function LandscapingTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#16a34a';

    // Gallery Images
    const galleryImages = [
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
        data.galleryImage4,
        data.galleryImage5,
        data.galleryImage6,
    ].filter(Boolean);

    // Testimonials
    const testimonials = [
        { name: data.clientName1, text: data.clientReview1, rating: Number(data.clientRating1) || 5 },
        { name: data.clientName2, text: data.clientReview2, rating: Number(data.clientRating2) || 5 },
        { name: data.clientName3, text: data.clientReview3, rating: Number(data.clientRating3) || 5 },
    ].filter(t => t.name && t.text);

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero Section */}
            <header className="relative min-h-[600px] text-white overflow-hidden flex items-center" style={{ backgroundColor: primaryColor }}>
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1558904541-efa843a96f01?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-40" />

                {data.heroImage && (
                    <img src={data.heroImage} alt="Hero" className="absolute inset-0 w-full h-full object-cover z-0" />
                )}

                <div className="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent z-10" />

                <div className="relative container mx-auto px-4 z-20 grid md:grid-cols-2 gap-12 items-center pt-20">
                    <div className="text-center md:text-right">
                        <div className="inline-flex items-center gap-2 px-4 py-2 bg-white/20 backdrop-blur-sm rounded-full text-sm font-bold mb-6 border border-white/30 animate-fade-in">
                            <Leaf className="w-4 h-4 text-green-300" />
                            <span>نحول الخيال إلى واقع أخضر</span>
                        </div>
                        <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight drop-shadow-lg">{data.heroTitle}</h1>
                        <p className="text-lg md:text-2xl mb-10 text-gray-100 max-w-xl shadow-black drop-shadow-md leading-relaxed">{data.heroDescription}</p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center md:justify-start">
                            <a
                                href={`tel:${data.phone}`}
                                className="bg-white hover:bg-gray-100 text-green-700 px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-all transform hover:scale-105 shadow-xl"
                            >
                                <Phone className="w-5 h-5" />
                                اتصل الآن: {data.phone}
                            </a>
                            {data.whatsapp && (
                                <a href={`https://wa.me/${data.whatsapp}`} className="bg-green-600 hover:bg-green-700 text-white px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-all transform hover:scale-105 shadow-xl border border-white/20">
                                    <MessageCircle className="w-5 h-5" />
                                    واتساب
                                </a>
                            )}
                        </div>
                    </div>
                </div>
            </header>

            {/* Stats Section */}
            <section className="relative z-30 -mt-16 container mx-auto px-4 mb-20">
                <div className="bg-white rounded-2xl shadow-xl p-8 grid grid-cols-2 md:grid-cols-4 gap-8 text-center border border-gray-100/50">
                    <div>
                        <div className="text-4xl font-bold mb-2 text-green-600">{data.yearsExperience || '10+'}</div>
                        <div className="text-gray-500 font-medium">سنوات خبرة</div>
                    </div>
                    <div>
                        <div className="text-4xl font-bold mb-2 text-green-600">{data.completedProjects || '100+'}</div>
                        <div className="text-gray-500 font-medium">مشروع ناجح</div>
                    </div>
                    <div>
                        <Leaf className="w-10 h-10 mx-auto mb-2 text-green-600" />
                        <div className="text-gray-500 font-medium">تصاميم عصرية</div>
                    </div>
                    <div>
                        <Sun className="w-10 h-10 mx-auto mb-2 text-yellow-500" />
                        <div className="text-gray-500 font-medium">صيانة دورية</div>
                    </div>
                </div>
            </section>

            {/* Services Section */}
            <section className="py-20 bg-gray-50">
                <div className="container mx-auto px-4">
                    <div className="text-center mb-16">
                        <span className="text-green-600 font-bold tracking-wider uppercase text-sm mb-2 block">خدماتنا</span>
                        <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-900">نعتني بجمال حديقتك</h2>
                        <div className="w-24 h-1 mx-auto rounded-full" style={{ backgroundColor: primaryColor }}></div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-8">
                        {/* Service 1 */}
                        <div className="group p-8 bg-white rounded-3xl hover:-translate-y-2 transition-all duration-300 shadow-sm hover:shadow-xl border border-gray-100">
                            <div className="w-16 h-16 bg-green-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-green-600 transition-colors duration-300 transform group-hover:rotate-6">
                                <Trees className="w-8 h-8 text-green-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4 text-gray-900">{data.service1Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service1Desc}</p>
                        </div>

                        {/* Service 2 */}
                        <div className="group p-8 bg-white rounded-3xl hover:-translate-y-2 transition-all duration-300 shadow-sm hover:shadow-xl border border-gray-100">
                            <div className="w-16 h-16 bg-green-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-green-600 transition-colors duration-300 transform group-hover:rotate-6">
                                <Flower2 className="w-8 h-8 text-green-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4 text-gray-900">{data.service2Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service2Desc}</p>
                        </div>

                        {/* Service 3 */}
                        <div className="group p-8 bg-white rounded-3xl hover:-translate-y-2 transition-all duration-300 shadow-sm hover:shadow-xl border border-gray-100">
                            <div className="w-16 h-16 bg-green-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-green-600 transition-colors duration-300 transform group-hover:rotate-6">
                                <Droplets className="w-8 h-8 text-green-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-4 text-gray-900">{data.service3Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service3Desc}</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <GallerySection
                images={galleryImages}
                title={data.galleryTitle}
                primaryColor={primaryColor}
            />

            {/* Testimonials Section */}
            <TestimonialsSection
                testimonials={testimonials}
                primaryColor={primaryColor}
            />

            {/* CTA Section */}
            <section className="py-24 text-white relative overflow-hidden flex items-center" style={{ backgroundColor: primaryColor }}>
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1585320806297-9794b3e4eeae?auto=format&fit=crop&q=80')] bg-cover bg-fixed opacity-10 mix-blend-overlay" />
                <div className="container mx-auto px-4 relative z-10 text-center">
                    <Sprout className="w-16 h-16 mx-auto mb-6 text-green-200 animate-bounce" />
                    <h2 className="text-4xl md:text-5xl font-bold mb-8 tracking-tight">جاهز لتحويل حديقتك إلى جنة؟</h2>
                    <p className="text-xl text-white/90 mb-10 max-w-2xl mx-auto leading-relaxed">تواصل معنا اليوم للحصول على استشارة مجانية وعرض سعر مخصص لمشروعك.</p>
                    <a href={`tel:${data.phone}`} className="inline-flex items-center gap-3 bg-white hover:bg-gray-50 text-green-700 px-12 py-5 rounded-full font-bold transition-all shadow-2xl text-lg transform hover:scale-105">
                        <Phone className="w-6 h-6" />
                        اتصل بنا: {data.phone}
                    </a>
                </div>
            </section>

            {/* Footer */}
            <footer className="bg-gray-900 text-gray-400 py-12 border-t border-gray-800">
                <div className="container mx-auto px-4 text-center">
                    <h3 className="text-2xl font-bold text-white mb-4">{data.companyName}</h3>
                    <p className="mb-8">نصنع الجمال في كل زاوية.</p>
                    <div className="flex justify-center gap-4 mb-8">
                        <a href={`tel:${data.phone}`} className="w-10 h-10 rounded-full bg-gray-800 hover:bg-gray-700 flex items-center justify-center transition-colors">
                            <Phone className="w-4 h-4 text-white" />
                        </a>
                        <a href={`https://wa.me/${data.whatsapp}`} className="w-10 h-10 rounded-full bg-gray-800 hover:bg-gray-700 flex items-center justify-center transition-colors">
                            <MessageCircle className="w-4 h-4 text-white" />
                        </a>
                    </div>
                    <p className="text-sm border-t border-gray-800 pt-8">&copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.</p>
                </div>
            </footer>
        </div>
    );
}
