import { Phone, MessageCircle, Truck, Package, ShieldCheck, Clock, CheckCircle2 } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection';

export default function MovingTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#1e3a8a';

    // Prepare Gallery Images
    const galleryImages = [
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
    ].filter(Boolean);

    // Prepare Testimonials
    const testimonials = [
        { name: data.clientName1, text: data.clientReview1, rating: 5 },
        { name: data.clientName2, text: data.clientReview2, rating: 5 },
    ].filter(t => t.name && t.text);

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero Section */}
            <header className="relative py-24 text-white overflow-hidden">
                <div
                    className="absolute inset-0 bg-cover bg-center"
                    style={{
                        backgroundImage: `url('https://images.unsplash.com/photo-1600518464441-9154a4dea21b?auto=format&fit=crop&q=80')`,
                    }}
                />
                <div className="absolute inset-0 bg-gradient-to-r from-blue-900/90 to-blue-900/70" />

                <div className="container mx-auto px-4 relative z-10 flex flex-col md:flex-row items-center gap-12">
                    <div className="flex-1 text-center md:text-right">
                        <div className="inline-block px-4 py-1 bg-yellow-400 text-blue-900 rounded-full font-bold text-sm mb-6 animate-pulse">
                            خدمة 24/7 في جميع المناطق
                        </div>
                        <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">{data.heroTitle}</h1>
                        <p className="text-lg md:text-xl mb-8 text-blue-100 max-w-xl leading-relaxed">{data.heroDescription}</p>
                        <div className="flex flex-col sm:flex-row gap-4 justify-center md:justify-start">
                            <a href={`tel:${data.phone}`} className="bg-yellow-500 hover:bg-yellow-400 text-blue-900 px-8 py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-all transform hover:scale-105 shadow-xl">
                                <Phone className="w-5 h-5" />
                                اتصل الآن: {data.phone}
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-white/10 backdrop-blur-md text-white hover:bg-white/20 px-8 py-4 rounded-xl font-bold flex items-center justify-center gap-2 transition-all border border-white/30">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>
                    {/* Decorative Image Card */}
                    <div className="flex-1 hidden md:block relative">
                        <div className="absolute -inset-4 bg-yellow-400 rounded-2xl opacity-20 transform rotate-6 blur-lg"></div>
                        <img
                            src="https://images.unsplash.com/photo-1603796846097-b36d7280d726?auto=format&fit=crop&q=80"
                            alt="Moving Service"
                            className="relative rounded-2xl shadow-2xl border-4 border-white/10 transform -rotate-2 hover:rotate-0 transition-transform duration-500"
                        />
                    </div>
                </div>
            </header>

            {/* Features Section */}
            <section className="py-20 bg-gray-50">
                <div className="container mx-auto px-4">
                    <div className="text-center mb-16">
                        <h2 className="text-3xl font-bold text-gray-900 mb-4">لماذا تختارنا؟</h2>
                        <div className="w-20 h-1 bg-yellow-400 mx-auto rounded-full"></div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-8">
                        {[
                            { icon: Truck, title: data.feature1, desc: 'أسطول حديث ومجهز لنقل جميع أنواع الأثاث' },
                            { icon: Package, title: data.feature2, desc: 'مواد تغليف عالية الجودة لحماية المنقولات' },
                            { icon: Clock, title: data.feature3, desc: 'دقة في المواعيد وسرعة في الإنجاز وتفريغ' },
                        ].map((item, idx) => (
                            <div key={idx} className="bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 border border-gray-100 group">
                                <div className="w-16 h-16 bg-blue-50 text-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:bg-blue-600 group-hover:text-white transition-colors duration-300">
                                    <item.icon className="w-8 h-8" />
                                </div>
                                <h3 className="text-xl font-bold mb-3 text-center">{item.title}</h3>
                                <p className="text-gray-500 text-center leading-relaxed">{item.desc}</p>
                            </div>
                        ))}
                    </div>
                </div>
            </section>

            {/* Process Section */}
            <section className="py-20 bg-white">
                <div className="container mx-auto px-4">
                    <div className="flex flex-col md:flex-row items-center gap-16">
                        <div className="flex-1">
                            <h2 className="text-3xl md:text-4xl font-bold mb-8 text-gray-900 leading-tight">خطوات عمل مدروسة<br /><span className="text-blue-600">لضمان سلامة عفشك</span></h2>
                            <div className="space-y-8">
                                {[
                                    { title: data.step1Title, desc: 'نقوم بمعاينة العفش وتحديد التكلفة والموعد المناسب.' },
                                    { title: data.step2Title, desc: 'فريق متخصص يقوم بفك وتغليف القطع بعناية فائقة.' },
                                    { title: data.step3Title, desc: 'نقل آمن وتركيب وترتيب الأثاث في منزلك الجديد.' },
                                ].map((step, i) => (
                                    <div key={i} className="flex gap-4">
                                        <div className="flex-shrink-0 w-12 h-12 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-xl ring-4 ring-white shadow-lg">
                                            {i + 1}
                                        </div>
                                        <div>
                                            <h4 className="text-xl font-bold mb-2">{step.title}</h4>
                                            <p className="text-gray-600">{step.desc}</p>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        </div>
                        <div className="flex-1 relative">
                            <div className="absolute inset-0 bg-blue-600 rounded-3xl transform rotate-3 opacity-10"></div>
                            <img
                                src="https://images.unsplash.com/photo-1600585154340-be6161a56a0c?auto=format&fit=crop&q=80"
                                alt="Moving Process"
                                className="relative rounded-3xl shadow-xl w-full object-cover h-[500px]"
                            />
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <GallerySection
                images={galleryImages}
                title={data.galleryTitle}
                primaryColor={primaryColor}
            />

            {/* Testimonials Section */}
            <TestimonialsSection
                testimonials={testimonials}
                primaryColor={primaryColor}
            />

            {/* Stats Section */}
            <section className="py-16 bg-blue-900 text-white">
                <div className="container mx-auto px-4">
                    <div className="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
                        <div>
                            <div className="text-4xl font-bold text-yellow-400 mb-2">1000+</div>
                            <div className="text-blue-200">عميل سعيد</div>
                        </div>
                        <div>
                            <div className="text-4xl font-bold text-yellow-400 mb-2">500+</div>
                            <div className="text-blue-200">عملية نقل</div>
                        </div>
                        <div>
                            <div className="text-4xl font-bold text-yellow-400 mb-2">100%</div>
                            <div className="text-blue-200">ضمان سلامة</div>
                        </div>
                        <div>
                            <div className="text-4xl font-bold text-yellow-400 mb-2">24/7</div>
                            <div className="text-blue-200">دعم فني</div>
                        </div>
                    </div>
                </div>
            </section>

            {/* Footer */}
            <footer className="bg-gray-900 text-white pt-16 pb-8">
                <div className="container mx-auto px-4 text-center">
                    <h2 className="text-3xl font-bold mb-6">{data.companyName}</h2>
                    <p className="text-gray-400 mb-8 max-w-lg mx-auto">خيارك الأول والموثوق لنقل العفش بأمان وسرعة. نخدم جميع مناطق المملكة بأعلى معايير الجودة.</p>
                    <div className="flex justify-center gap-4 mb-12">
                        <a href={`tel:${data.phone}`} className="w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors">
                            <Phone className="w-5 h-5" />
                        </a>
                        <a href={`https://wa.me/${data.whatsapp}`} className="w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors">
                            <MessageCircle className="w-5 h-5" />
                        </a>
                    </div>
                    <div className="border-t border-gray-800 pt-8 text-sm text-gray-500">
                        &copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.
                    </div>
                </div>
            </footer>
        </div>
    );
}
