import { Phone, MessageCircle, ShieldAlert, Bug, SprayCan, CheckCircle2, ShieldCheck, ThermometerSun } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection';

export default function PestControlTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#0ea5e9'; // Sky-500 default

    // Gallery Images
    const galleryImages = [
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
    ].filter(Boolean);

    // Testimonials
    const testimonials = [
        { name: data.clientName1, text: data.clientReview1, rating: 5 },
    ].filter(t => t.name && t.text);

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Top Bar - Urgent */}
            <div className="bg-red-600 text-white py-2 px-4 shadow-md relative z-20 overflow-hidden">
                <div className="container mx-auto flex justify-between items-center animate-pulse">
                    <span className="font-bold text-sm md:text-base flex items-center gap-2">
                        <ShieldAlert className="w-5 h-5" />
                        خدمة طوارئ 24 ساعة - نصلك فوراً
                    </span>
                    <a href={`tel:${data.phone}`} className="font-bold underline text-sm md:text-base">{data.phone}</a>
                </div>
            </div>

            {/* Hero Section */}
            <header className="relative min-h-[600px] flex items-center text-white overflow-hidden" style={{ backgroundColor: primaryColor }}>
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1584650541604-944208d132b0?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-20 mix-blend-overlay" />
                <div className="absolute inset-0 bg-gradient-to-r from-black/80 via-black/40 to-transparent" />

                <div className="container mx-auto px-4 relative z-10 grid md:grid-cols-2 gap-12 items-center">
                    <div className="animate-fade-in-right">
                        <div className="inline-block bg-white/20 backdrop-blur-md border border-white/30 rounded-full px-4 py-1.5 text-sm font-bold mb-6">
                            🛡️ {data.guarantee || 'ضمان شامل'}
                        </div>
                        <h1 className="text-4xl md:text-6xl font-black mb-6 leading-tight drop-shadow-lg">
                            {data.heroTitle}
                        </h1>
                        <p className="text-xl md:text-2xl text-white/90 mb-10 leading-relaxed font-light">
                            {data.heroDescription}
                        </p>
                        <div className="flex flex-col sm:flex-row gap-4">
                            <a href={`tel:${data.phone}`} className="bg-white text-gray-900 px-8 py-4 rounded-lg font-bold hover:bg-gray-100 transition-all shadow-xl flex items-center justify-center gap-3 transform hover:-translate-y-1">
                                <Phone className="w-5 h-5" />
                                اتصل الآن: {data.phone}
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-green-500 text-white px-8 py-4 rounded-lg font-bold hover:bg-green-600 transition-all shadow-xl flex items-center justify-center gap-3 transform hover:-translate-y-1">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>

                    {/* Hero Image/Illustration Element */}
                    <div className="hidden md:block relative animate-fade-in-up">
                        <div className="relative z-10 bg-white/10 backdrop-blur p-8 rounded-2xl border border-white/20 shadow-2xl">
                            <h3 className="text-xl font-bold mb-6 border-b border-white/20 pb-4">لماذا نحن الأفضل؟</h3>
                            <ul className="space-y-4">
                                <li className="flex items-center gap-3">
                                    <div className="p-1 bg-green-500 rounded-full"><CheckCircle2 className="w-4 h-4 text-white" /></div>
                                    <span>مبيدات مصرحة وآمنة تماماً</span>
                                </li>
                                <li className="flex items-center gap-3">
                                    <div className="p-1 bg-green-500 rounded-full"><CheckCircle2 className="w-4 h-4 text-white" /></div>
                                    <span>بدون رائحة وبدون مغادرة المنزل</span>
                                </li>
                                <li className="flex items-center gap-3">
                                    <div className="p-1 bg-green-500 rounded-full"><CheckCircle2 className="w-4 h-4 text-white" /></div>
                                    <span>فنيون محترفون ومعتمدون</span>
                                </li>
                                <li className="flex items-center gap-3">
                                    <div className="p-1 bg-green-500 rounded-full"><CheckCircle2 className="w-4 h-4 text-white" /></div>
                                    <span>ضمان حقيقي يصل لـ 6 أشهر</span>
                                </li>
                            </ul>
                        </div>
                        {/* Blob Effect */}
                        <div className="absolute -top-10 -right-10 w-32 h-32 bg-yellow-400 rounded-full mix-blend-multiply filter blur-2xl opacity-50 animate-blob"></div>
                        <div className="absolute -bottom-10 -left-10 w-32 h-32 bg-green-400 rounded-full mix-blend-multiply filter blur-2xl opacity-50 animate-blob animation-delay-2000"></div>
                    </div>
                </div>
            </header>

            {/* Services Grid */}
            <section className="py-20 bg-gray-50">
                <div className="container mx-auto px-4">
                    <div className="text-center mb-16">
                        <h2 className="text-3xl font-bold mb-4 text-gray-900">خدمات المكافحة الشاملة</h2>
                        <div className="w-16 h-1 bg-blue-500 mx-auto rounded-full"></div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-8">
                        {/* Service 1 */}
                        <div className="bg-white p-8 rounded-2xl shadow-sm hover:shadow-lg transition-shadow border border-gray-100 group">
                            <div className="w-16 h-16 bg-blue-50 rounded-full flex items-center justify-center mb-6 group-hover:bg-blue-600 transition-colors">
                                <Bug className="w-8 h-8 text-blue-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-3 text-gray-900">مكافحة الحشرات الزاحفة</h3>
                            <p className="text-gray-500 leading-relaxed">قضاء تام على الصراصير والنمل بجل ألماني آمن وبدون رائحة مع الضمان.</p>
                        </div>

                        {/* Service 2 */}
                        <div className="bg-white p-8 rounded-2xl shadow-sm hover:shadow-lg transition-shadow border border-gray-100 group">
                            <div className="w-16 h-16 bg-red-50 rounded-full flex items-center justify-center mb-6 group-hover:bg-red-600 transition-colors">
                                <SprayCan className="w-8 h-8 text-red-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-3 text-gray-900">مكافحة بق الفراش</h3>
                            <p className="text-gray-500 leading-relaxed">تقنية الرش المزدوج والمكافحة الحرارية لضمان القضاء على البق وبيضه.</p>
                        </div>

                        {/* Service 3 */}
                        <div className="bg-white p-8 rounded-2xl shadow-sm hover:shadow-lg transition-shadow border border-gray-100 group">
                            <div className="w-16 h-16 bg-green-50 rounded-full flex items-center justify-center mb-6 group-hover:bg-green-600 transition-colors">
                                <ShieldCheck className="w-8 h-8 text-green-600 group-hover:text-white transition-colors" />
                            </div>
                            <h3 className="text-xl font-bold mb-3 text-gray-900">الوقاية والتعقيم</h3>
                            <p className="text-gray-500 leading-relaxed">عقود صيانة دورية للمطاعم والمستودعات والفلل لضمان بيئة خالية من الآفات.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Features (Values) */}
            <section className="py-20 bg-white">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-3 gap-8 text-center">
                        <div className="p-6">
                            <div className="w-12 h-12 mx-auto mb-4 bg-green-100 rounded-full flex items-center justify-center">
                                <CheckCircle2 className="w-6 h-6 text-green-600" />
                            </div>
                            <h4 className="font-bold text-lg mb-2">{data.feature1 || 'مبيدات آمنة'}</h4>
                            <p className="text-gray-500 text-sm">مصرحة من وزارة الصحة وآمنة على الأطفال والحيوانات الأليفة.</p>
                        </div>
                        <div className="p-6">
                            <div className="w-12 h-12 mx-auto mb-4 bg-blue-100 rounded-full flex items-center justify-center">
                                <ThermometerSun className="w-6 h-6 text-blue-600" />
                            </div>
                            <h4 className="font-bold text-lg mb-2">{data.feature2 || 'بدون رائحة'}</h4>
                            <p className="text-gray-500 text-sm">لا تحتاج لمغادرة المنزل أو إزالة الأواني، راحة تامة أثناء الخدمة.</p>
                        </div>
                        <div className="p-6">
                            <div className="w-12 h-12 mx-auto mb-4 bg-orange-100 rounded-full flex items-center justify-center">
                                <ShieldCheck className="w-6 h-6 text-orange-600" />
                            </div>
                            <h4 className="font-bold text-lg mb-2">{data.guarantee || 'ضمان معتمد'}</h4>
                            <p className="text-gray-500 text-sm">نقدم ضمان حقيقي ومتابعة مجانية في حال ظهور الحشرات مرة أخرى.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <GallerySection
                images={galleryImages}
                title={data.galleryTitle}
                primaryColor={primaryColor}
            />

            {/* Testimonials Section */}
            <TestimonialsSection
                testimonials={testimonials}
                primaryColor={primaryColor}
            />

            {/* CTA Bottom */}
            <section className="py-16 bg-gray-900 text-white text-center">
                <div className="container mx-auto px-4">
                    <h2 className="text-3xl font-bold mb-6">احمي منزلك وعائلتك اليوم</h2>
                    <p className="text-gray-400 mb-8 text-lg">اتصل نصلك أينما كنت. معاينة مجانية وخصومات خاصة للعقود السنوية.</p>
                    <div className="flex justify-center gap-4">
                        <a href={`tel:${data.phone}`} className="bg-blue-600 hover:bg-blue-500 text-white px-8 py-3 rounded-full font-bold transition-all shadow-lg flex items-center gap-2">
                            <Phone className="w-5 h-5" />
                            {data.phone}
                        </a>
                    </div>
                </div>
            </section>

            <footer className="bg-gray-950 text-gray-500 py-8 text-center border-t border-gray-900">
                <div className="container mx-auto px-4">
                    <p>&copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.</p>
                </div>
            </footer>
        </div>
    );
}
