import { Phone, MessageCircle, Globe, Users, CheckCircle, FileCheck, Plane, FileText, UserCheck, Star } from 'lucide-react';
import GallerySection from './shared/GallerySection';
import TestimonialsSection from './shared/TestimonialsSection'; // Using generic section even if fields are manually mapped

export default function RecruitmentTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#0891b2'; // Cyan-600

    // Gallery Images
    const galleryImages = [
        data.galleryImage1,
        data.galleryImage2,
        data.galleryImage3,
    ].filter(Boolean);

    // Testimonials
    const testimonials = [
        { name: data.clientName1, text: data.clientReview1, rating: 5 },
    ].filter(t => t.name && t.text);

    return (
        <div className="font-sans text-gray-800 bg-gray-50 min-h-full" dir="rtl">
            {/* Navbar-like Header */}
            <div className="bg-white shadow-sm py-4 sticky top-0 z-50">
                <div className="container mx-auto px-4 flex justify-between items-center">
                    <h1 className="text-2xl font-bold text-gray-900 flex items-center gap-2">
                        <Plane className="w-8 h-8 text-cyan-600" />
                        {data.companyName}
                    </h1>
                    <div className="text-sm font-medium text-gray-600 bg-gray-100 px-4 py-2 rounded-full">
                        {data.licenseNumber && <span>{data.licenseNumber}</span>}
                    </div>
                </div>
            </div>

            {/* Hero */}
            <header className="relative bg-cyan-900 text-white py-24 overflow-hidden">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1521791136064-7986c2920216?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-10" />
                <div className="absolute inset-0 bg-gradient-to-r from-cyan-900/90 to-cyan-800/80" />

                <div className="container mx-auto px-4 flex flex-col md:flex-row items-center gap-12 relative z-10">
                    <div className="flex-1 animate-fade-in-right">
                        <div className="inline-block bg-cyan-800/50 backdrop-blur px-4 py-1 rounded-full text-cyan-200 text-sm font-bold mb-6 border border-cyan-700">
                            استقدام موثوق وسريع
                        </div>
                        <h2 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">{data.heroTitle}</h2>
                        <p className="text-lg text-cyan-100 mb-10 leading-relaxed max-w-xl">{data.heroDescription}</p>
                        <div className="flex flex-col sm:flex-row gap-4">
                            <a href={`tel:${data.phone}`} className="bg-white text-cyan-900 px-8 py-4 rounded-lg font-bold hover:bg-gray-100 transition-all flex items-center justify-center gap-2 shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                                <Phone className="w-5 h-5" />
                                اتصل بنا
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-green-500 text-white px-8 py-4 rounded-lg font-bold hover:bg-green-600 transition-all flex items-center justify-center gap-2 shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>

                    {/* Floating Card */}
                    <div className="flex-1 w-full max-w-md bg-white text-gray-800 p-8 rounded-2xl shadow-2xl animate-fade-in-up border-t-8 border-cyan-500">
                        <h3 className="text-xl font-bold mb-6 pb-4 border-b border-gray-100">لماذا تختار {data.companyName}؟</h3>
                        <ul className="space-y-4">
                            <li className="flex items-start gap-3">
                                <div className="p-1 bg-green-100 rounded-full mt-1">
                                    <CheckCircle className="w-5 h-5 text-green-600" />
                                </div>
                                <div>
                                    <h4 className="font-bold text-gray-900">{data.feature1 || 'سرعة في الإنجاز'}</h4>
                                    <p className="text-sm text-gray-500">ننهي إجراءاتك في وقت قياسي.</p>
                                </div>
                            </li>
                            <li className="flex items-start gap-3">
                                <div className="p-1 bg-green-100 rounded-full mt-1">
                                    <Users className="w-5 h-5 text-green-600" />
                                </div>
                                <div>
                                    <h4 className="font-bold text-gray-900">{data.feature2 || 'عمالة مدربة'}</h4>
                                    <p className="text-sm text-gray-500">عمالة مختارة بعناية وكفاءة عالية.</p>
                                </div>
                            </li>
                            <li className="flex items-start gap-3">
                                <div className="p-1 bg-green-100 rounded-full mt-1">
                                    <FileCheck className="w-5 h-5 text-green-600" />
                                </div>
                                <div>
                                    <h4 className="font-bold text-gray-900">{data.feature3 || 'ضمان شامل'}</h4>
                                    <p className="text-sm text-gray-500">نضمن حقوقك وحقوق العمالة.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </header>

            {/* Countries Section - Modern Cards */}
            <section className="py-20 bg-white">
                <div className="container mx-auto px-4 text-center">
                    <div className="mb-12">
                        <span className="text-cyan-600 font-bold uppercase tracking-wider text-sm">وجهاتنا</span>
                        <h2 className="text-3xl font-bold text-gray-900 mt-2">دول الاستقدام المتاحة</h2>
                    </div>

                    <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
                        {data.countries?.split('-').map((country, i) => (
                            <div key={i} className="group bg-gray-50 hover:bg-white p-6 rounded-xl shadow-sm hover:shadow-lg border border-gray-100 hover:border-cyan-200 transition-all duration-300">
                                <div className="w-16 h-16 bg-white rounded-full flex items-center justify-center mx-auto mb-4 shadow-sm group-hover:scale-110 transition-transform">
                                    <Globe className="w-8 h-8 text-cyan-600" />
                                </div>
                                <h3 className="font-bold text-lg text-gray-800 group-hover:text-cyan-700 transition-colors">{country.trim()}</h3>
                            </div>
                        )) || <p>الفلبين - إندونيسيا - كينيا - أوغندا</p>}
                    </div>
                </div>
            </section>

            {/* Application Process Steps */}
            <section className="py-20 bg-gray-50 border-t border-gray-100">
                <div className="container mx-auto px-4">
                    <h2 className="text-3xl font-bold text-center mb-16 text-gray-900">رحلة الاستقدام معنا</h2>
                    <div className="grid md:grid-cols-4 gap-8 relative">
                        {/* Connecting Line (Hidden on Mobile) */}
                        <div className="hidden md:block absolute top-12 left-0 w-full h-1 bg-gray-200 -z-0"></div>

                        <div className="relative z-10 text-center group">
                            <div className="w-24 h-24 bg-white border-4 border-gray-100 rounded-full flex items-center justify-center mx-auto mb-6 shadow-sm group-hover:border-cyan-500 transition-colors duration-300">
                                <FileText className="w-10 h-10 text-gray-400 group-hover:text-cyan-600 transition-colors" />
                            </div>
                            <h3 className="font-bold text-xl mb-2">1. اختيار السيرة الذاتية</h3>
                            <p className="text-gray-500">اختر العمالة المناسبة لاحتياجاتك من قاعدة بياناتنا.</p>
                        </div>

                        <div className="relative z-10 text-center group">
                            <div className="w-24 h-24 bg-white border-4 border-gray-100 rounded-full flex items-center justify-center mx-auto mb-6 shadow-sm group-hover:border-cyan-500 transition-colors duration-300">
                                <FileCheck className="w-10 h-10 text-gray-400 group-hover:text-cyan-600 transition-colors" />
                            </div>
                            <h3 className="font-bold text-xl mb-2">2. إصدار التأشيرة</h3>
                            <p className="text-gray-500">نقوم بجميع الإجراءات الحكومية واستخراج التأشيرة.</p>
                        </div>

                        <div className="relative z-10 text-center group">
                            <div className="w-24 h-24 bg-white border-4 border-gray-100 rounded-full flex items-center justify-center mx-auto mb-6 shadow-sm group-hover:border-cyan-500 transition-colors duration-300">
                                <UserCheck className="w-10 h-10 text-gray-400 group-hover:text-cyan-600 transition-colors" />
                            </div>
                            <h3 className="font-bold text-xl mb-2">3. التعاقد</h3>
                            <p className="text-gray-500">توقيع العقود الرسمية وتوثيقها عبر مساند.</p>
                        </div>

                        <div className="relative z-10 text-center group">
                            <div className="w-24 h-24 bg-white border-4 border-gray-100 rounded-full flex items-center justify-center mx-auto mb-6 shadow-sm group-hover:border-cyan-500 transition-colors duration-300">
                                <Plane className="w-10 h-10 text-gray-400 group-hover:text-cyan-600 transition-colors" />
                            </div>
                            <h3 className="font-bold text-xl mb-2">4. الوصول</h3>
                            <p className="text-gray-500">استقبال العمالة وتوصيلها إليك.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Gallery Section */}
            <GallerySection
                images={galleryImages}
                title={data.galleryTitle}
                primaryColor={primaryColor}
            />

            {/* Testimonials Section */}
            <TestimonialsSection
                testimonials={testimonials}
                primaryColor={primaryColor}
            />

            <footer className="bg-cyan-950 text-white py-12 text-center border-t border-cyan-900">
                <div className="container mx-auto px-4">
                    <h2 className="text-2xl font-bold mb-4">{data.companyName}</h2>
                    <p className="text-cyan-200/60 mb-8 max-w-lg mx-auto">مرخص من وزارة الموارد البشرية والتنمية الاجتماعية. نسعى دائماً لخدمتكم بأعلى معايير الجودة.</p>
                    <div className="text-sm font-medium opacity-50">
                        &copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.
                    </div>
                </div>
            </footer>
        </div>
    );
}
