import { Star, Quote } from 'lucide-react';

interface Testimonial {
    name: string;
    text: string;
    location?: string;
    rating?: number;
}

interface TestimonialsSectionProps {
    testimonials: Testimonial[];
    title?: string;
    primaryColor?: string;
}

export default function TestimonialsSection({
    testimonials,
    title = "آراء عملائنا",
    primaryColor = "#16a34a"
}: TestimonialsSectionProps) {
    if (!testimonials || testimonials.length === 0) return null;

    return (
        <section className="py-20 bg-gray-50 overflow-hidden">
            <div className="container mx-auto px-4">
                <div className="text-center mb-16">
                    <h2 className="text-3xl md:text-4xl font-bold mb-4" style={{ color: primaryColor }}>{title}</h2>
                    <div className="w-24 h-1 mx-auto rounded-full" style={{ backgroundColor: primaryColor }}></div>
                </div>

                <div className="grid md:grid-cols-3 gap-8">
                    {testimonials.map((item, index) => (
                        <div
                            key={index}
                            className="bg-white p-8 rounded-2xl shadow-sm hover:shadow-xl transition-shadow duration-300 relative border border-gray-100"
                        >
                            <Quote className="absolute top-6 left-6 text-gray-100 w-16 h-16 -z-0 rotate-180" />
                            <div className="relative z-10">
                                <div className="flex gap-1 mb-4">
                                    {[...Array(item.rating || 5)].map((_, i) => (
                                        <Star key={i} className="w-5 h-5 fill-yellow-400 text-yellow-400" />
                                    ))}
                                </div>
                                <p className="text-gray-600 mb-6 leading-relaxed min-h-[80px]">"{item.text}"</p>
                                <div className="flex items-center gap-4 border-t border-gray-100 pt-4">
                                    <div className="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center font-bold text-lg text-gray-500">
                                        {item.name.charAt(0)}
                                    </div>
                                    <div>
                                        <h4 className="font-bold text-gray-900">{item.name}</h4>
                                        {item.location && <span className="text-sm text-gray-500">{item.location}</span>}
                                    </div>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
