# دليل نشر التطبيق على cPanel

هذا الدليل يشرح كيفية نشر تطبيق استخراج الأرقام من خرائط جوجل على استضافة cPanel.

## الخطوات

### 1. رفع الملفات إلى cPanel

1. قم بتسجيل الدخول إلى حساب cPanel الخاص بك.
2. انتقل إلى مدير الملفات (File Manager).
3. قم برفع جميع ملفات المشروع إلى المجلد الذي تريد استضافة التطبيق فيه (مثل `public_html` أو مجلد فرعي).

### 2. إعداد Node.js في cPanel

1. من لوحة تحكم cPanel، ابحث عن قسم "Setup Node.js App" أو "Node.js Selector".
2. انقر على "Create Application".
3. حدد المسار الذي قمت برفع الملفات إليه.
4. اختر أحدث إصدار من Node.js.
5. في حقل "Application Mode"، اختر "Production".
6. في حقل "Application Root"، أدخل المسار إلى مجلد التطبيق.
7. في حقل "Application URL"، أدخل عنوان URL الذي سيستخدم للوصول إلى التطبيق.
8. في حقل "Application Startup File"، أدخل `start.js`.
9. انقر على "Create".

### 3. تكوين ملف .env

قم بإنشاء أو تعديل ملف `.env` في مجلد التطبيق وتأكد من أنه يحتوي على:

```
GOOGLE_MAPS_API_KEY=AIzaSyCJL5AtuVmHrEyrSaVaqmF0uAForUNZTeY
PORT=8080
```

ملاحظة: قد يختلف رقم المنفذ (PORT) حسب إعدادات cPanel الخاصة بك. استخدم المنفذ الذي تم تعيينه لتطبيقك في cPanel.

### 4. تكوين ملف .htaccess

تأكد من أن ملف `.htaccess` موجود في مجلد التطبيق الرئيسي ويحتوي على:

```
RewriteEngine On
RewriteRule ^api/(.*)$ http://localhost:8080/api/$1 [P,L]
```

استبدل `8080` برقم المنفذ الذي تم تعيينه لتطبيقك في cPanel.

### 5. تشغيل التطبيق

1. من قسم "Setup Node.js App" في cPanel، ابحث عن تطبيقك في القائمة.
2. انقر على زر "Run JS Script".
3. تأكد من أن التطبيق يعمل بنجاح من خلال مراقبة سجلات التطبيق.

### 6. اختبار التطبيق

1. افتح متصفح الويب وانتقل إلى عنوان URL الخاص بتطبيقك.
2. تأكد من أن واجهة المستخدم تظهر بشكل صحيح.
3. قم بإجراء بحث للتأكد من أن التطبيق يعمل بشكل صحيح ويعرض بيانات حقيقية.

## استكشاف الأخطاء وإصلاحها

إذا واجهت مشاكل في الحصول على بيانات حقيقية، تحقق من:

1. **مفتاح API**: تأكد من أن مفتاح Google Maps API صالح وليس مقيدًا بنطاق معين.
2. **سجلات التطبيق**: راجع سجلات Node.js في cPanel للتحقق من وجود أي أخطاء.
3. **تكوين الخادم الوسيط**: تأكد من أن ملف `.htaccess` مكون بشكل صحيح ويستخدم المنفذ الصحيح.
4. **ملف config.js**: تأكد من أن `proxyUrl` في ملف `config.js` مضبوط على `/api/places/search`.

## ملاحظات إضافية

- تأكد من أن مفتاح Google Maps API مسموح له بالعمل من نطاق موقعك على cPanel.
- قد تحتاج إلى تكوين CORS في cPanel للسماح بالطلبات من نطاقك.
- إذا كان لديك نطاق فرعي أو مسار مخصص، قد تحتاج إلى تعديل `proxyUrl` في `config.js` ليكون مسارًا مطلقًا بدلاً من مسار نسبي.
