# 🚀 دليل النشر على VPS - برو كود v2.0

## 📋 المتطلبات

### على السيرفر (VPS)
- Node.js v18+
- حساب مستخدم عادي (لا يشترط sudo)
- 256MB RAM على الأقل
- اتصال إنترنت

### على جهازك المحلي
- WinSCP أو FileZilla (لرفع الملفات)
- PuTTY أو SSH client (للاتصال بالسيرفر)

---

## 📦 الخطوة 1: تحضير الملفات

### 1.1 الملفات المطلوبة للنشر

قم بضغط المجلد بالكامل **باستثناء**:
- `node_modules/` (سيتم تثبيتها على السيرفر)
- `.git/`
- `tokens/`
- `.env` (ستنشئه على السيرفر)
- أي ملفات logs

### 1.2 قائمة الملفات الأساسية:
```
✅ server.js (الجديد - محسّن للذاكرة)
✅ auth.js (الجديد - مع retry mechanism)
✅ app.js (الجديد - modular)
✅ index.html (الجديد - UI احترافي)
✅ login.html (الجديد)
✅ admin-panel.html
✅ design-system.css (الجديد)
✅ package.json
✅ package-lock.json
```

---

## 🔧 الخطوة 2: رفع الملفات على VPS

### 2.1 استخدام cPanel File Manager

1. افتح cPanel
2. اذهب إلى **File Manager**
3. انتقل إلى المجلد الرئيسي لموقعك (مثلاً `public_html` أو `vc.techprocode.com`)
4. ارفع ملف ZIP
5. فك الضغط

### 2.2 أو استخدام FTP/SFTP

```bash
# مثال باستخدام scp
scp -r /path/to/project user@your-vps-ip:/path/to/destination
```

---

## ⚙️ الخطوة 3: التثبيت على السيرفر

### 3.1 الاتصال بالسيرفر عبر SSH

```bash
ssh user@your-vps-ip
# أو من cPanel Terminal
```

### 3.2 الانتقال لمجلد المشروع

```bash
cd /path/to/your/project
# مثلاً:
cd vc.techprocode.com
```

### 3.3 تثبيت المكتبات

```bash
npm install --production
```

**ملحوظة:** استخدم `--production` لتثبيت المكتبات الأساسية فقط (يقلل استخدام الذاكرة)

---

## 🔑 الخطوة 4: إعداد ملف البيئة (.env)

قم بإنشاء ملف `.env` في المجلد الرئيسي:

```bash
nano .env
```

أضف المحتوى التالي:

```env
# Server Configuration
PORT=8080
NODE_ENV=production
NODE_OPTIONS=--max-old-space-size=256

# Google Maps API
GOOGLE_MAPS_API_KEY=AIzaSyAYGuFwowyd5OZ-ZTkw1MQMqpHdKturxS8

# WhatsApp Cloud API (اختياري - للمستقبل)
WHATSAPP_TOKEN=your_token_here
WHATSAPP_PHONE_NUMBER_ID=your_phone_id_here

# AI APIs (اختياري)
OPENAI_API_KEY=your_openai_key
DEEPSEEK_API_KEY=your_deepseek_key
```

احفظ الملف: `Ctrl + X` ثم `Y` ثم `Enter`

---

## 🚀 الخطوة 5: تشغيل التطبيق

### الطريقة الموصى بها: nohup

```bash
# تشغيل في الخلفية
nohup node server.js > logs/app.log 2>&1 &

# للتحقق من حالة التطبيق
ps aux | grep "node server.js"
```

### إيقاف التطبيق

```bash
# البحث عن process ID
ps aux | grep "node server.js"

# إيقاف التطبيق
kill -9 <PID>

# أو إيقاف جميع عمليات node
pkill -f "node server.js"
```

### إعادة التشغيل

```bash
# إيقاف
pkill -f "node server.js"

# تشغيل
nohup node server.js > logs/app.log 2>&1 &
```

---

## 📊 الخطوة 6: التحقق من التشغيل

### 6.1 فحص الصحة (Health Check)

```bash
curl http://localhost:8080/health
```

يجب أن ترى:
```json
{
  "status": "healthy",
  "uptime": 123.45,
  "memory": {...},
  "timestamp": "2025-12-26T..."
}
```

### 6.2 اختبار البحث

```bash
curl "http://localhost:8080/api/places/search?keyword=cafe&location=Riyadh&resultCount=5"
```

### 6.3 عرض السجلات (Logs)

```bash
# عرض آخر 50 سطر
tail -n 50 logs/app.log

# متابعة السجلات مباشرة
tail -f logs/app.log
```

---

## 🌐 الخطوة 7: إعداد Nginx (Reverse Proxy)

إذا كانت لديك صلاحيات sudo، يفضل إعداد Nginx:

```nginx
# /etc/nginx/sites-available/vc.techprocode.com

server {
    listen 80;
    server_name vc.techprocode.com www.vc.techprocode.com;

    location / {
        proxy_pass http://localhost:8080;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    }
}
```

تفعيل:
```bash
sudo ln -s /etc/nginx/sites-available/vc.techprocode.com /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl reload nginx
```

---

## 🔧 استكشاف الأخطاء

### المشكلة: "Out of Memory"

**الحل:**
```bash
# في ملف .env، تأكد من:
NODE_OPTIONS=--max-old-space-size=256
```

### المشكلة: "EADDRINUSE (Port already in use)"

**الحل:**
```bash
# إيقاف العملية القديمة
pkill -f "node server.js"

# أو تغيير البورت في .env
PORT=8081
```

### المشكلة: "Firebase Config not found"

**الأسباب المحتملة:**
1. ملف `auth.js` غير محدّث (استخدم النسخة الجديدة المدمجة)
2. Firebase SDK لم يتم تحميله

**الحل:** تأكد من رفع ملف `auth.js` الجديد الذي يحتوي على الإعدادات المدمجة

### المشكلة: "503 Service Unavailable"

**الحل:**
```bash
# تحقق من السجلات
tail -n 100 logs/app.log

# تأكد من عدم وجود أخطاء في بدء التشغيل
# أعد التشغيل
pkill -f "node server.js"
nohup node server.js > logs/app.log 2>&1 &
```

---

## 🔄 التحديثات المستقبلية

### لتحديث الكود:

1. **على جهازك المحلي:**
   - قم بتعديل الكود
   - اختبر محلياً
   - اضغط الملفات المحدّثة

2. **على السيرفر:**
   ```bash
   # إيقاف التطبيق
   pkill -f "node server.js"
   
   # رفع الملفات الجديدة (عبر FTP)
   
   # إذا كان هناك مكتبات جديدة
   npm install --production
   
   # إعادة التشغيل
   nohup node server.js > logs/app.log 2>&1 &
   ```

---

## 📝 نصائح الأداء

### 1. تنظيف السجلات

```bash
# حذف السجلات القديمة (أكثر من 7 أيام)
find logs/ -type f -name "*.log" -mtime +7 -delete
```

### 2. مراقبة استخدام الذاكرة

```bash
# عرض استخدام الذاكرة
ps aux | grep node | awk '{print $2, $4, $11}'
```

### 3. Cron Job للتنظيف التلقائي

```bash
crontab -e

# أضف السطر التالي (تنظيف يومي الساعة 3 صباحاً)
0 3 * * * find /path/to/project/logs/ -type f -mtime +7 -delete
```

---

## ✅ قائمة التحقق النهائية

- [ ] جميع الملفات مرفوعة على السيرفر
- [ ] `npm install` تم تشغيله بنجاح
- [ ] ملف `.env` تم إنشاؤه بالمفاتيح الصحيحة
- [ ] التطبيق يعمل: `curl http://localhost:8080/health`
- [ ] البحث يعمل (نتائج حقيقية، ليست وهمية)
- [ ] Firebase يعمل (تسجيل الدخول ناجح)
- [ ] Admin panel يعمل
- [ ] Nginx مضبوط (إن وجد)

---

## 🆘 الدعم

إذا واجهت أي مشاكل:

1. **تحقق من السجلات:**
   ```bash
   tail -n 100 logs/app.log
   ```

2. **أعد التشغيل:**
   ```bash
   pkill -f "node server.js"
   nohup node server.js > logs/app.log 2>&1 &
   ```

3. **تحقق من الصحة:**
   ```bash
   curl http://localhost:8080/health
   ```

---

## 🎉 تم!

تطبيقك الآن يعمل على VPS بشكل احترافي ومحسّن للذاكرة!

**الوصول:**
- الموقع: `http://your-domain.com`
- الصحة: `http://your-domain.com/health`
- API: `http://your-domain.com/api/places/search`

**ملاحظات مهمة:**
- ✅ لا حاجة لـ PM2 (nohup أخف وأبسط)
- ✅ لا حاجة لـ Chrome (WhatsApp QR معطّل مؤقتاً)
- ✅ استخدام axios تم استبداله بـ https native
- ✅ Firebase config مدمج في auth.js

**استمتع! 🚀**
