# برو كود - ابداع يتجاوز الحدود

تطبيق ويب احترافي يقوم بجلب بيانات الأعمال التجارية (مثل: اسم النشاط، العنوان، رقم الهاتف، الموقع على الخريطة) من خرائط Google Maps بناءً على كلمات مفتاحية وموقع جغرافي محدد.

## المميزات

- واجهة مستخدم بسيطة وسهلة الاستخدام باللغة العربية
- البحث عن الأعمال التجارية حسب الكلمة المفتاحية والموقع
- عرض النتائج في جدول منظم
- إمكانية تصدير البيانات بصيغة Excel
- تصميم متجاوب يعمل على جميع الأجهزة

## متطلبات النظام

- Node.js (الإصدار 14 أو أحدث)
- مفتاح Google Maps API (Places API)

## طريقة الإعداد

### 1. الحصول على مفتاح Google Maps API

1. قم بزيارة [Google Cloud Console](https://console.cloud.google.com/)
2. قم بإنشاء مشروع جديد
3. قم بتفعيل الخدمات التالية:
   - Places API
   - Maps JavaScript API
4. انتقل إلى "Credentials" وقم بإنشاء مفتاح API جديد
5. قم بتقييد استخدام المفتاح (مستحسن):
   - تقييد حسب HTTP referrer (موقع الويب الخاص بك)
   - تقييد حسب IP address (عنوان IP الخاص بك)

### 2. إعداد التطبيق

1. قم بتثبيت الحزم المطلوبة:
   ```
   npm install
   ```

2. قم بتعديل ملف `.env` وإضافة مفتاح API الخاص بك:
   ```
   GOOGLE_MAPS_API_KEY=your_api_key_here
   ```

3. قم بتعديل ملف `config.js` وتغيير قيمة `useProxy` إلى `true` إذا كنت تستخدم الخادم المحلي:
   ```javascript
   useProxy: true,
   proxyUrl: "http://localhost:3000/api/places/search"
   ```

### 3. تشغيل التطبيق

1. قم بتشغيل الخادم المحلي:
   ```
   npm start
   ```

2. افتح المتصفح وانتقل إلى:
   ```
   http://localhost:3000
   ```

## ملاحظات مهمة

- يرجى الالتزام بسياسات استخدام Google Maps API وشروط الخدمة
- الحساب المجاني في Google Cloud Platform يوفر رصيد شهري محدود للاستخدام
- قم بمراقبة استهلاك API الخاص بك لتجنب الرسوم الإضافية

## طريقة الاستخدام

1. أدخل الكلمة المفتاحية (مثل: مطاعم، محلات ملابس، صالونات حلاقة)
2. أدخل الموقع الجغرافي (مثل: الرياض، دبي، القاهرة)
3. اضغط على زر "بحث"
4. انتظر حتى تظهر النتائج
5. يمكنك تصدير النتائج إلى ملف Excel بالضغط على زر "تصدير إلى Excel"

## هيكل المشروع

- `index.html` - واجهة المستخدم الرئيسية
- `styles.css` - ملف التنسيق
- `app.js` - الكود الرئيسي للتطبيق
- `config.js` - إعدادات التطبيق ومفتاح API
- `server.js` - خادم Express لتجنب مشاكل CORS وإخفاء مفتاح API
- `.env` - ملف المتغيرات البيئية

## الترخيص

هذا المشروع مرخص تحت رخصة MIT.
