/**
 * سكريبت لإضافة مجموعة من المستخدمين الاختباريين إلى النظام
 */
 
function createUserId() {
    return Date.now().toString() + Math.floor(Math.random() * 1000).toString();
}

function hashPassword(password) {
    // هذه دالة بسيطة لتمثيل تشفير كلمة المرور (في الإنتاج يجب استخدام تشفير حقيقي)
    return btoa(password);
}

function createNewUsers() {
    // الحصول على المستخدمين الحاليين
    const currentUsers = JSON.parse(localStorage.getItem('users') || '[]');
    console.log('عدد المستخدمين الحاليين:', currentUsers.length);

    // قائمة البريد الإلكتروني للمستخدمين الجدد
    const newUserEmails = [
        'asmaa234er@gamil.com',
        'Esraa.lacoste2025@gamil.com',
        'saraezz2025@gmail.com',
        'nourhassam366@gamil.com',
        'fhlae2345@gmail.com',
        'ea0423639@gmail.com',
        'hendh9060@gmail.com'
    ];

    // كلمة المرور المشتركة
    const commonPassword = '123456';
    const hashedPassword = hashPassword(commonPassword);
    
    // إنشاء المستخدمين الجدد
    const newUsers = newUserEmails.map(email => {
        // استخراج الاسم من البريد الإلكتروني
        const emailParts = email.split('@');
        const namePart = emailParts[0];
        const name = namePart.charAt(0).toUpperCase() + namePart.slice(1);
        
        return {
            id: createUserId(),
            name: name,
            email: email,
            password: hashedPassword,
            registrationDate: new Date().toISOString(),
            isActive: false,
            activationPending: true,
            isAdmin: false,
            points: 0,
            savedSearches: []
        };
    });
    
    console.log('عدد المستخدمين الجدد:', newUsers.length);
    console.log('بيانات المستخدمين الجدد:', newUsers);
    
    // التحقق من عدم وجود حساب بنفس البريد الإلكتروني
    const allEmails = currentUsers.map(user => user.email.toLowerCase());
    const uniqueNewUsers = newUsers.filter(user => !allEmails.includes(user.email.toLowerCase()));
    
    if (uniqueNewUsers.length < newUsers.length) {
        console.warn(`تم تجاهل ${newUsers.length - uniqueNewUsers.length} مستخدم بسبب تكرار البريد الإلكتروني`);
    }
    
    // إضافة المستخدمين الجدد إلى القائمة
    const updatedUsers = [...currentUsers, ...uniqueNewUsers];
    
    // حفظ القائمة المحدثة
    try {
        localStorage.setItem('users', JSON.stringify(updatedUsers));
        console.log('تم إضافة المستخدمين الجدد بنجاح!');
        console.log('العدد الإجمالي للمستخدمين الآن:', updatedUsers.length);
        return true;
    } catch (error) {
        console.error('حدث خطأ أثناء حفظ المستخدمين:', error);
        return false;
    }
}

// تنفيذ الإضافة
const result = createNewUsers();
if (result) {
    alert('تم إضافة المستخدمين بنجاح! يمكن للمدير تفعيل حساباتهم من لوحة التحكم');
} else {
    alert('حدث خطأ أثناء إضافة المستخدمين');
}
