<?php
// تعيين رؤوس CORS للسماح بالوصول من أي مصدر
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");

// تفعيل عرض الأخطاء للتشخيص
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// كتابة سجل للتشخيص
$logFile = __DIR__ . '/api-proxy.log';
function writeLog($message) {
    global $logFile;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

writeLog("بدء تنفيذ وسيط API");

// التعامل مع طلبات OPTIONS (للتعامل مع طلبات preflight CORS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// مفتاح Google Maps API
$apiKey = "AIzaSyAYGuFwowyd5OZ-ZTkw1MQMqpHdKturxS8";

// الحصول على معلمات البحث
$keyword = isset($_GET['keyword']) ? $_GET['keyword'] : '';
$location = isset($_GET['location']) ? $_GET['location'] : '';
$resultCount = isset($_GET['resultCount']) ? intval($_GET['resultCount']) : 20;

writeLog("معلمات البحث: keyword=$keyword, location=$location, resultCount=$resultCount");

// التحقق من وجود المعلمات المطلوبة
if (empty($keyword) || empty($location)) {
    writeLog("خطأ: الكلمة المفتاحية والموقع مطلوبان");
    echo json_encode([
        'error' => 'Keyword and location are required',
        'results' => []
    ]);
    exit;
}

// تحديد الحد الأقصى لعدد النتائج
$maxResults = min($resultCount, 100);

// بناء URL للبحث عن الأماكن
$placesApiUrl = "https://maps.googleapis.com/maps/api/place/textsearch/json?";
$placesApiUrl .= "query=" . urlencode($keyword . " in " . $location);
$placesApiUrl .= "&key=" . $apiKey;
$placesApiUrl .= "&language=ar";

writeLog("URL البحث: " . $placesApiUrl);

// استخدام cURL بدلاً من file_get_contents للمزيد من المرونة
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $placesApiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

$placesResponse = curl_exec($ch);

if (curl_errno($ch)) {
    writeLog("خطأ cURL: " . curl_error($ch));
    echo json_encode([
        'error' => 'Failed to connect to Google API: ' . curl_error($ch),
        'results' => []
    ]);
    curl_close($ch);
    exit;
}

curl_close($ch);

// تحويل الاستجابة إلى كائن JSON
$placesData = json_decode($placesResponse, true);

writeLog("حالة استجابة API: " . ($placesData['status'] ?? 'غير معروف'));
writeLog("عدد النتائج: " . (isset($placesData['results']) ? count($placesData['results']) : 0));

// التحقق من وجود نتائج
if (!isset($placesData['results']) || empty($placesData['results'])) {
    writeLog("لم يتم العثور على نتائج من API");
    echo json_encode([
        'status' => $placesData['status'] ?? 'UNKNOWN_ERROR',
        'results' => []
    ]);
    exit;
}

// الحصول على تفاصيل كل مكان
$detailedResults = [];
$limit = min($maxResults, count($placesData['results']));

writeLog("جاري معالجة $limit من النتائج");

for ($i = 0; $i < $limit; $i++) {
    $place = $placesData['results'][$i];
    writeLog("معالجة المكان: " . $place['name'] . " (ID: " . $place['place_id'] . ")");
    
    // بناء URL للحصول على تفاصيل المكان
    $detailsApiUrl = "https://maps.googleapis.com/maps/api/place/details/json?";
    $detailsApiUrl .= "place_id=" . $place['place_id'];
    $detailsApiUrl .= "&fields=name,formatted_address,formatted_phone_number,place_id";
    $detailsApiUrl .= "&key=" . $apiKey;
    $detailsApiUrl .= "&language=ar";
    
    // استخدام cURL للحصول على تفاصيل المكان
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $detailsApiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    $detailsResponse = curl_exec($ch);
    
    if (curl_errno($ch)) {
        writeLog("خطأ cURL عند الحصول على تفاصيل المكان: " . curl_error($ch));
        // إذا فشل الحصول على التفاصيل، أضف المعلومات الأساسية
        $detailedResults[] = [
            'name' => $place['name'],
            'formatted_address' => $place['formatted_address'],
            'place_id' => $place['place_id']
        ];
        curl_close($ch);
        continue;
    }
    
    curl_close($ch);
    
    $detailsData = json_decode($detailsResponse, true);
    
    if (isset($detailsData['result'])) {
        writeLog("تم الحصول على تفاصيل المكان بنجاح");
        $detailedResults[] = $detailsData['result'];
    } else {
        writeLog("لم يتم العثور على تفاصيل للمكان");
        // إذا لم نتمكن من الحصول على التفاصيل، أضف المعلومات الأساسية
        $detailedResults[] = [
            'name' => $place['name'],
            'formatted_address' => $place['formatted_address'],
            'place_id' => $place['place_id']
        ];
    }
    
    // إضافة تأخير قصير لتجنب تجاوز حدود API
    usleep(100000); // 100 مللي ثانية
}

writeLog("تم الانتهاء من معالجة " . count($detailedResults) . " مكان");

// إرجاع النتائج
$response = [
    'status' => 'OK',
    'results' => $detailedResults
];

writeLog("إرسال الاستجابة النهائية");
echo json_encode($response);
?>
