"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.yo = void 0;
const lolcatjs_1 = __importDefault(require("lolcatjs"));
const is_in_browser_1 = require("is-in-browser");
const index_1 = require("./index");
const yo = function (str, opt) {
    if ((opt === null || opt === void 0 ? void 0 : opt.color) !== 'rainbow') {
        return index_1.yo(str, opt);
    }
    if (is_in_browser_1.isBrowser) {
        throw Error('not support rainbow in browsers now');
    }
    opt.silent = true;
    const lines = index_1.yo(str, opt);
    lolcatjs_1.default.fromString(lines.join('\n'));
    return lines;
};
exports.yo = yo;
