// This file is used as the entry point for cPanel Node.js applications
const cluster = require('cluster');
const numCPUs = require('os').cpus().length;
const path = require('path');

// Get the port from cPanel environment or use a default
const PORT = process.env.PORT || 8080;

if (cluster.isMaster) {
    console.log(`Master ${process.pid} is running`);
    console.log(`Starting server on port ${PORT}`);

    // Fork workers equal to CPU count
    for (let i = 0; i < numCPUs; i++) {
        cluster.fork();
    }

    cluster.on('exit', (worker, code, signal) => {
        console.log(`Worker ${worker.process.pid} died`);
        // Replace the dead worker
        cluster.fork();
    });
} else {
    // Workers can share any TCP connection
    // In this case it is an HTTP server
    require('./server.js');
    console.log(`Worker ${process.pid} started`);
}
