#!/bin/bash

# ============================================
# Stop Script for WhatsApp Business Scraper
# ============================================

echo "🛑 Stopping WhatsApp Business Scraper..."

# Find and kill all node server.js processes
PIDS=$(ps aux | grep "node server.js" | grep -v grep | awk '{print $2}')

if [ -z "$PIDS" ]; then
    echo "ℹ️  No running processes found"
else
    echo "📴 Stopping processes: $PIDS"
    kill -9 $PIDS 2>/dev/null
    echo "✅ Server stopped"
fi

# Show final status
sleep 1
if ps aux | grep "node server.js" | grep -v grep > /dev/null; then
    echo "⚠️  Some processes may still be running"
else
    echo "✅ All processes stopped successfully"
fi
