const axios = require('axios');

async function testGoogleMapsAPI() {
    try {
        console.log('بدء اختبار الاتصال بـ Google Maps API...');
        const apiKey = 'AIzaSyCJL5AtuVmHrEyrSaVaqmF0uAForUNZTeY';
        
        console.log('إرسال طلب إلى Google Places API...');
        const response = await axios.get('https://maps.googleapis.com/maps/api/place/textsearch/json', {
            params: {
                query: 'مطاعم في دبي',
                key: apiKey,
                language: 'ar'
            }
        });
        
        console.log('حالة استجابة API:', response.data.status);
        console.log('عدد النتائج:', response.data.results ? response.data.results.length : 0);
        
        if (response.data.results && response.data.results.length > 0) {
            console.log('النتيجة الأولى:', response.data.results[0].name);
            console.log('العنوان:', response.data.results[0].formatted_address);
        }
        
        // اختبار الحصول على تفاصيل مكان
        if (response.data.results && response.data.results.length > 0) {
            const placeId = response.data.results[0].place_id;
            console.log('الحصول على تفاصيل المكان بمعرف:', placeId);
            
            const detailsResponse = await axios.get('https://maps.googleapis.com/maps/api/place/details/json', {
                params: {
                    place_id: placeId,
                    fields: 'name,formatted_address,formatted_phone_number',
                    key: apiKey,
                    language: 'ar'
                }
            });
            
            console.log('حالة استجابة تفاصيل المكان:', detailsResponse.data.status);
            if (detailsResponse.data.result) {
                console.log('اسم المكان:', detailsResponse.data.result.name);
                console.log('رقم الهاتف:', detailsResponse.data.result.formatted_phone_number || 'غير متوفر');
            }
        }
    } catch (error) {
        console.error('خطأ في اختبار API:', error.message);
        if (error.response) {
            console.error('استجابة خطأ API:', error.response.data);
        }
    }
}

// تشغيل الاختبار
testGoogleMapsAPI();
